/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.bson;

import de.bwaldvogel.mongo.bson.Bson;
import java.time.Instant;
import java.util.Objects;

public final class BsonTimestamp
implements Bson,
Comparable<BsonTimestamp> {
    private static final long serialVersionUID = 1L;
    private final long value;

    protected BsonTimestamp() {
        this(0L);
    }

    public BsonTimestamp(long value) {
        this.value = value;
    }

    public BsonTimestamp(Instant instant, int increment) {
        this.value = instant.getEpochSecond() << 32 | (long)increment & 0xFFFFFFFFL;
    }

    public long getValue() {
        return this.value;
    }

    public int getTime() {
        return (int)(this.value >> 32);
    }

    public int getInc() {
        return (int)this.value;
    }

    public String toString() {
        return "BsonTimestamp[value=" + this.getValue() + ", seconds=" + this.getTime() + ", inc=" + this.getInc() + "]";
    }

    @Override
    public int compareTo(BsonTimestamp other) {
        return Long.compareUnsigned(this.value, other.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonTimestamp other = (BsonTimestamp)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }
}

