/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.Json;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.stream.Stream;

public class ReplaceRootStage
implements AggregationStage {
    private final Object newRoot;

    public ReplaceRootStage(Document document) {
        this.newRoot = document.getOrMissing("newRoot");
        if (Missing.isNullOrMissing(this.newRoot)) {
            throw new MongoServerError(40231, "no newRoot specified for the $replaceRoot stage");
        }
    }

    @Override
    public String name() {
        return "$replaceRoot";
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::replaceRoot);
    }

    Document replaceRoot(Document document) {
        Object evaluatedNewRoot = Expression.evaluateDocument(this.newRoot, document);
        if (!(evaluatedNewRoot instanceof Document)) {
            throw new MongoServerError(40228, "'newRoot' expression must evaluate to an object, but resulting value was: " + Json.toJsonValue(evaluatedNewRoot, true, "{", "}") + ". Type of resulting value: '" + Utils.describeType(evaluatedNewRoot) + "'. Input document: " + document.toString(true));
        }
        return (Document)evaluatedNewRoot;
    }
}

