/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.backend.QueryResult;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.wire.MongoWireProtocolHandler;
import de.bwaldvogel.mongo.wire.ReplyFlag;
import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoMessage;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoReply;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDatabaseHandler
extends SimpleChannelInboundHandler<ClientRequest> {
    private static final Logger log = LoggerFactory.getLogger(MongoWireProtocolHandler.class);
    private final AtomicInteger idSequence = new AtomicInteger();
    private final MongoBackend mongoBackend;
    private final ChannelGroup channelGroup;

    public MongoDatabaseHandler(MongoBackend mongoBackend, ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        this.mongoBackend = mongoBackend;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channelGroup.add((Object)ctx.channel());
        log.info("client {} connected", (Object)ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        log.info("channel {} closed", (Object)ctx.channel());
        this.channelGroup.remove((Object)ctx.channel());
        this.mongoBackend.handleClose(ctx.channel());
        super.channelInactive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ClientRequest object) {
        if (object instanceof MongoQuery) {
            MongoReply mongoReply = this.handleQuery((MongoQuery)object);
            ctx.channel().writeAndFlush((Object)mongoReply);
        } else if (object instanceof MongoMessage) {
            MongoMessage response = this.handleMessage((MongoMessage)object);
            ctx.channel().writeAndFlush((Object)response);
        } else {
            throw new MongoServerException("unknown message: " + object);
        }
    }

    MongoMessage handleMessage(MongoMessage message) {
        Document document = null;
        try {
            document = this.mongoBackend.handleMessage(message);
        }
        catch (MongoServerException e) {
            log.error("failed to handle {}", (Object)message.getDocument(), (Object)e);
            document = this.errorResponse(e, Collections.emptyMap());
        }
        catch (RuntimeException ex) {
            log.error("Unknown error!", (Throwable)ex);
            MongoServerException e = new MongoServerException("Unknown error: " + ex.getMessage(), ex);
            document = this.errorResponse(e, Collections.emptyMap());
        }
        return new MongoMessage(message.getChannel(), this.createResponseHeader(message), document);
    }

    private MongoReply handleQuery(MongoQuery query) {
        if (query.getCollectionName().startsWith("$cmd")) {
            Document document = this.handleCommand(query);
            MessageHeader header = this.createResponseHeader(query);
            return new MongoReply(header, document != null ? Collections.singletonList(document) : Collections.emptyList(), 0L, new ReplyFlag[0]);
        }
        QueryResult queryResult = this.mongoBackend.handleQuery(query);
        MessageHeader header = this.createResponseHeader(query);
        return new MongoReply(header, queryResult != null ? queryResult.collectDocuments() : Collections.emptyList(), queryResult != null ? queryResult.getCursorId() : 0L, new ReplyFlag[0]);
    }

    private MessageHeader createResponseHeader(ClientRequest request) {
        return new MessageHeader(this.idSequence.incrementAndGet(), request.getHeader().getRequestID());
    }

    private Document errorResponse(MongoServerException exception, Map<String, ?> additionalInfo) {
        Document obj = new Document();
        obj.put("$err", (Object)exception.getMessageWithoutErrorCode());
        obj.put("errmsg", (Object)exception.getMessageWithoutErrorCode());
        if (exception instanceof MongoServerError) {
            MongoServerError error = (MongoServerError)exception;
            obj.put("code", (Object)error.getCode());
            obj.putIfNotNull("codeName", error.getCodeName());
        }
        obj.putAll((Map<? extends String, ?>)additionalInfo);
        obj.put("ok", (Object)0);
        return obj;
    }

    Document handleCommand(MongoQuery query) {
        String collectionName = query.getCollectionName();
        if ("$cmd.sys.inprog".equals(collectionName)) {
            Collection<Document> currentOperations = this.mongoBackend.getCurrentOperations(query);
            return new Document("inprog", currentOperations);
        }
        if ("$cmd".equals(collectionName)) {
            String command;
            switch (command = query.getQuery().keySet().iterator().next()) {
                case "serverStatus": {
                    return this.mongoBackend.getServerStatus();
                }
                case "ping": {
                    Document response = new Document();
                    Utils.markOkay(response);
                    return response;
                }
            }
            Document actualQuery = query.getQuery();
            if ("$query".equals(command)) {
                command = ((Document)query.getQuery().get("$query")).keySet().iterator().next();
                actualQuery = (Document)actualQuery.get("$query");
            }
            return this.mongoBackend.handleCommand(query.getChannel(), query.getDatabaseName(), command, actualQuery);
        }
        throw new MongoServerException("unknown collection: " + collectionName);
    }
}

