/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.Constants;
import de.bwaldvogel.mongo.backend.Cursor;
import de.bwaldvogel.mongo.backend.EmptyCursor;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.ObjectId;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.DollarPrefixedFieldNameException;
import de.bwaldvogel.mongo.exception.ErrorCode;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.PathNotViableException;
import de.bwaldvogel.mongo.wire.bson.BsonEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Utils {
    public static final String PATH_DELIMITER = ".";
    private static final Pattern PATH_DELIMITER_PATTERN = Pattern.compile(Pattern.quote("."));

    static void validateKey(String key) {
        if (key.endsWith(PATH_DELIMITER)) {
            throw new MongoServerError(ErrorCode._40353, "FieldPath must not end with a '.'.");
        }
        if (key.startsWith(PATH_DELIMITER) || key.contains("..")) {
            throw new MongoServerError(ErrorCode._15998, "FieldPath field names may not be empty strings.");
        }
    }

    public static Object getSubdocumentValue(Document document, String key) {
        return Utils.getSubdocumentValue(document, key, false);
    }

    public static Object getSubdocumentValueCollectionAware(Document document, String key) {
        return Utils.getSubdocumentValue(document, key, true);
    }

    private static Object getSubdocumentValue(Document document, String key, boolean handleCollections) {
        Utils.validateKey(key);
        List<String> pathFragments = Utils.splitPath(key);
        if (pathFragments.size() == 1) {
            return Utils.getFieldValueListSafe(document, CollectionUtils.getSingleElement(pathFragments));
        }
        String mainKey = pathFragments.get(0);
        String subKey = Utils.joinTail(pathFragments);
        Assert.doesNotStartWith(subKey, "$.");
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document) {
            return Utils.getSubdocumentValue((Document)subObject, subKey, handleCollections);
        }
        if (handleCollections && subObject instanceof Collection) {
            Collection values = (Collection)subObject;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : values) {
                if (o instanceof Document) {
                    Object subdocumentValue = Utils.getSubdocumentValue((Document)o, subKey, handleCollections);
                    if (subdocumentValue instanceof Collection) {
                        result.addAll((Collection)subdocumentValue);
                        continue;
                    }
                    result.add(subdocumentValue);
                    continue;
                }
                result.add(Missing.getInstance());
            }
            return result;
        }
        return Missing.getInstance();
    }

    public static String getDatabaseNameFromFullName(String fullName) {
        return Utils.firstFragment(fullName);
    }

    public static String getCollectionNameFromFullName(String fullName) {
        return fullName.substring(fullName.indexOf(PATH_DELIMITER) + 1);
    }

    public static boolean isTrue(Object value) {
        if (Missing.isNullOrMissing(value)) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return true;
    }

    static Object normalizeValue(Object value) {
        if (Missing.isNullOrMissing(value)) {
            return null;
        }
        if (value instanceof Long && Utils.cannotBeRepresentedAsDouble((Long)value)) {
            return value;
        }
        if (value instanceof Number) {
            double doubleValue = ((Number)value).doubleValue();
            if (doubleValue == -0.0) {
                doubleValue = 0.0;
            }
            return doubleValue;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            Document result = new Document();
            for (Map.Entry entry : map.entrySet()) {
                result.put((String)entry.getKey(), Utils.normalizeValue(entry.getValue()));
            }
            return result;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.stream().map(Utils::normalizeValue).collect(Collectors.toList());
        }
        return value;
    }

    private static boolean cannotBeRepresentedAsDouble(Long value) {
        return value != (long)value.doubleValue();
    }

    public static Number normalizeNumber(Number value) {
        if (value == null) {
            return null;
        }
        double doubleValue = value.doubleValue();
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            return doubleValue;
        }
        if ((double)value.intValue() == doubleValue) {
            return value.intValue();
        }
        if ((double)value.longValue() == doubleValue) {
            return value.longValue();
        }
        return doubleValue;
    }

    static boolean nullAwareEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (Missing.isNullOrMissing(a) && Missing.isNullOrMissing(b)) {
            return true;
        }
        if (Missing.isNullOrMissing(a) || Missing.isNullOrMissing(b)) {
            return false;
        }
        Object normalizedA = Utils.normalizeValue(a);
        Object normalizedB = Utils.normalizeValue(b);
        return Objects.equals(normalizedA, normalizedB);
    }

    static int calculateSize(Document document) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            BsonEncoder.encodeDocument(document, buffer);
            int n = buffer.writerIndex();
            return n;
        }
        catch (RuntimeException e) {
            throw new MongoServerException("Failed to calculate document size", e);
        }
        finally {
            buffer.release();
        }
    }

    static boolean containsQueryExpression(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof Document)) {
            return false;
        }
        Document doc = (Document)value;
        for (String key : doc.keySet()) {
            if (key.startsWith("$")) {
                return true;
            }
            if (!Utils.containsQueryExpression(doc.get(key))) continue;
            return true;
        }
        return false;
    }

    static Object getFieldValueListSafe(Object value, String field) throws IllegalArgumentException {
        if (Missing.isNullOrMissing(value)) {
            return Missing.getInstance();
        }
        if (field.equals("$") || field.contains(PATH_DELIMITER)) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (value instanceof List) {
            List list = (List)value;
            if (Utils.isNumeric(field)) {
                int pos = Integer.parseInt(field);
                if (pos >= 0 && pos < list.size()) {
                    return list.get(pos);
                }
                return Missing.getInstance();
            }
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object subValue : list) {
                Object subDocumentValue;
                if (!(subValue instanceof Document) || (subDocumentValue = ((Document)subValue).getOrMissing(field)) instanceof Missing) continue;
                values.add(subDocumentValue);
            }
            if (values.isEmpty()) {
                return Missing.getInstance();
            }
            return values;
        }
        if (value instanceof Document) {
            Document document = (Document)value;
            return document.getOrMissing(field);
        }
        return Missing.getInstance();
    }

    private static boolean isNumeric(String value) {
        return value.chars().allMatch(Character::isDigit);
    }

    static boolean hasSubdocumentValue(Object document, String key) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            return Utils.hasFieldValueListSafe(document, key);
        }
        String subKey = Utils.getSubkey(pathFragments, new AtomicReference<Integer>());
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document || subObject instanceof List) {
            return Utils.hasSubdocumentValue(subObject, subKey);
        }
        return false;
    }

    static boolean canFullyTraverseSubkeyForRename(Object document, String key) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            return true;
        }
        String subKey = Utils.getSubkey(pathFragments, new AtomicReference<Integer>());
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document) {
            return Utils.canFullyTraverseSubkeyForRename(subObject, subKey);
        }
        return subObject instanceof Missing;
    }

    static String getSubkey(List<String> pathFragments, AtomicReference<Integer> matchPos) {
        String key = Utils.joinPath(pathFragments);
        if (key.matches(".*\\$(\\.).+\\$(\\.).*")) {
            throw new BadValueException("Too many positional (i.e. '$') elements found in path '" + key + "'");
        }
        String subKey = Utils.joinTail(pathFragments);
        if (subKey.matches("\\$(\\..+)?")) {
            if (matchPos == null || matchPos.get() == null) {
                throw new BadValueException("The positional operator did not find the match needed from the query.");
            }
            Integer pos = matchPos.getAndSet(null);
            return subKey.replaceFirst("\\$", String.valueOf(pos));
        }
        return subKey;
    }

    static boolean hasFieldValueListSafe(Object document, String field) throws IllegalArgumentException {
        if (document == null) {
            return false;
        }
        if (field.equals("$") || field.contains(PATH_DELIMITER)) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof List) {
            if (Utils.isNumeric(field)) {
                int pos = Integer.parseInt(field);
                List list = (List)document;
                return pos >= 0 && pos < list.size();
            }
            return false;
        }
        if (document instanceof Document) {
            return ((Document)document).containsKey(field);
        }
        throw new IllegalArgumentException("illegal document: " + document);
    }

    public static void markOkay(Document result) {
        result.put("ok", (Object)1.0);
    }

    private static void setListSafe(Object document, String key, String previousKey, Object obj) {
        if (document instanceof List) {
            List list = (List)document;
            if (!Utils.isNumeric(key)) {
                String element = new Document(previousKey, document).toString(true);
                throw new PathNotViableException("Cannot create field '" + key + "' in element " + element);
            }
            int pos = Integer.parseInt(key);
            while (list.size() <= pos) {
                list.add(null);
            }
            list.set(pos, obj);
        } else {
            Map documentAsMap = (Map)document;
            documentAsMap.put(key, obj);
        }
    }

    private static Object removeListSafe(Object value, String key) {
        if (value instanceof Document) {
            Document document = (Document)value;
            if (document.containsKey(key)) {
                return document.remove(key);
            }
            return Missing.getInstance();
        }
        if (value instanceof List) {
            List values = (List)value;
            if (Utils.isNumeric(key)) {
                int pos = Integer.parseInt(key);
                if (values.size() > pos) {
                    return values.set(pos, null);
                }
                return Missing.getInstance();
            }
            ArrayList<Object> removedValues = new ArrayList<Object>();
            for (Object subValue : values) {
                if (subValue instanceof Document) {
                    Object removedValue = Utils.removeListSafe(subValue, key);
                    if (removedValue instanceof Missing) continue;
                    removedValues.add(removedValue);
                    continue;
                }
                if (!(subValue instanceof List)) continue;
                List subValueList = (List)subValue;
                for (Object subValueListValue : subValueList) {
                    Object removedValue = Utils.removeListSafe(subValueListValue, key);
                    if (removedValue instanceof Missing) continue;
                    removedValues.add(removedValue);
                }
            }
            return removedValues;
        }
        return Missing.getInstance();
    }

    public static String join(List<?> values, String delimiter) {
        return values.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    static void changeSubdocumentValue(Object document, String key, Object newValue, Integer matchPos) {
        Utils.changeSubdocumentValue(document, key, newValue, new AtomicReference<Integer>(matchPos));
    }

    public static void changeSubdocumentValue(Object document, String key, Object newValue) {
        Utils.changeSubdocumentValue(document, key, newValue, new AtomicReference<Integer>());
    }

    static void changeSubdocumentValue(Object document, String key, Object newValue, AtomicReference<Integer> matchPos) {
        Utils.changeSubdocumentValue(document, key, newValue, null, matchPos);
    }

    private static void changeSubdocumentValue(Object document, String key, Object newValue, String previousKey, AtomicReference<Integer> matchPos) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            Utils.setListSafe(document, key, previousKey, newValue);
            return;
        }
        String subKey = Utils.getSubkey(pathFragments, matchPos);
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document || subObject instanceof List) {
            Utils.changeSubdocumentValue(subObject, subKey, newValue, mainKey, matchPos);
        } else {
            if (Missing.isNeitherNullNorMissing(subObject)) {
                String element = new Document(mainKey, subObject).toString(true);
                String subKeyFirst = Utils.splitPath(subKey).get(0);
                throw new PathNotViableException("Cannot create field '" + subKeyFirst + "' in element " + element);
            }
            Document obj = new Document();
            Utils.changeSubdocumentValue(obj, subKey, newValue, mainKey, matchPos);
            Utils.setListSafe(document, mainKey, previousKey, obj);
        }
    }

    public static void validateFieldNames(Document document) {
        Utils.validateFieldNames(document, null);
    }

    private static void validateFieldNames(Object value, String path) {
        block3: {
            block2: {
                if (!(value instanceof Document)) break block2;
                Document document = (Document)value;
                for (Map.Entry<String, Object> entry : document.entrySet()) {
                    String nextPath;
                    String key = entry.getKey();
                    String string = nextPath = path != null ? path + PATH_DELIMITER + key : key;
                    if (!key.startsWith("$") || Constants.REFERENCE_KEYS.contains(key)) continue;
                    throw new DollarPrefixedFieldNameException("The dollar ($) prefixed field '" + key + "' in '" + nextPath + "' is not allowed in the context of an update's replacement document. Consider using an aggregation pipeline with $replaceWith.");
                }
                break block3;
            }
            if (!(value instanceof Collection)) break block3;
            Collection values = (Collection)value;
            for (Object object : values) {
                Utils.validateFieldNames(object, path + PATH_DELIMITER);
            }
        }
    }

    static Object removeSubdocumentValue(Object document, String key, Integer matchPos) {
        return Utils.removeSubdocumentValue(document, key, new AtomicReference<Integer>(matchPos));
    }

    public static Object removeSubdocumentValue(Object document, String key) {
        return Utils.removeSubdocumentValue(document, key, new AtomicReference<Integer>());
    }

    private static Object removeSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) {
        List<String> pathFragments = Utils.splitPath(key);
        String mainKey = pathFragments.get(0);
        if (pathFragments.size() == 1) {
            return Utils.removeListSafe(document, key);
        }
        String subKey = Utils.getSubkey(pathFragments, matchPos);
        Assert.notNullOrEmpty(subKey);
        Object subObject = Utils.getFieldValueListSafe(document, mainKey);
        if (subObject instanceof Document || subObject instanceof List) {
            return Utils.removeSubdocumentValue(subObject, subKey, matchPos);
        }
        return Missing.getInstance();
    }

    public static String describeType(Object value) {
        if (value == null) {
            return "null";
        }
        return Utils.describeType(value.getClass());
    }

    public static String describeType(Class<?> type) {
        if (Missing.class.isAssignableFrom(type)) {
            return "missing";
        }
        if (Document.class.isAssignableFrom(type)) {
            return "object";
        }
        if (String.class.isAssignableFrom(type)) {
            return "string";
        }
        if (Collection.class.isAssignableFrom(type)) {
            return "array";
        }
        if (Integer.class.isAssignableFrom(type)) {
            return "int";
        }
        if (Long.class.isAssignableFrom(type)) {
            return "long";
        }
        if (Double.class.isAssignableFrom(type)) {
            return "double";
        }
        if (ObjectId.class.isAssignableFrom(type)) {
            return "objectId";
        }
        if (Instant.class.isAssignableFrom(type)) {
            return "date";
        }
        return type.getName();
    }

    static Document firstBatchCursorResponse(String ns, Document ... documents) {
        return Utils.firstBatchCursorResponse(ns, Arrays.asList(documents));
    }

    static Document firstBatchCursorResponse(String ns, Iterable<Document> documents) {
        ArrayList<Document> firstBatch = new ArrayList<Document>();
        for (Document document : documents) {
            firstBatch.add(document);
        }
        return Utils.firstBatchCursorResponse(ns, firstBatch);
    }

    static Document firstBatchCursorResponse(String ns, Stream<Document> firstBatch) {
        return Utils.firstBatchCursorResponse(ns, firstBatch.collect(Collectors.toList()));
    }

    static Document firstBatchCursorResponse(String ns, List<Document> firstBatch) {
        return Utils.firstBatchCursorResponse(ns, firstBatch, EmptyCursor.get());
    }

    static Document firstBatchCursorResponse(String ns, List<Document> firstBatch, Cursor cursor) {
        return Utils.firstBatchCursorResponse(ns, firstBatch, cursor.getId());
    }

    static Document firstBatchCursorResponse(String ns, List<Document> firstBatch, long cursorId) {
        return Utils.firstBatchCursorResponse(ns, "firstBatch", firstBatch, cursorId);
    }

    static Document nextBatchCursorResponse(String ns, List<Document> nextBatch, long cursorId) {
        return Utils.firstBatchCursorResponse(ns, "nextBatch", nextBatch, cursorId);
    }

    private static Document firstBatchCursorResponse(String ns, String key, List<Document> documents, long cursorId) {
        Document cursorResponse = new Document();
        cursorResponse.put("id", (Object)cursorId);
        cursorResponse.put("ns", (Object)ns);
        cursorResponse.put(key, (Object)documents);
        Document response = new Document();
        response.put("cursor", (Object)cursorResponse);
        Utils.markOkay(response);
        return response;
    }

    static String joinPath(String ... fragments) {
        return Stream.of(fragments).filter(fragment -> !fragment.isEmpty()).collect(Collectors.joining(PATH_DELIMITER));
    }

    public static String joinTail(List<String> pathFragments) {
        return pathFragments.stream().skip(1L).collect(Collectors.joining(PATH_DELIMITER));
    }

    static String joinPath(List<String> fragments) {
        return String.join((CharSequence)PATH_DELIMITER, fragments);
    }

    public static String firstFragment(String input) {
        int delimiterIndex = input.indexOf(PATH_DELIMITER);
        if (delimiterIndex == -1) {
            return input;
        }
        return input.substring(0, delimiterIndex);
    }

    public static List<String> splitPath(String input) {
        return PATH_DELIMITER_PATTERN.splitAsStream(input).collect(Collectors.toList());
    }

    static List<String> getTail(List<String> pathFragments) {
        return pathFragments.subList(1, pathFragments.size());
    }

    public static String getShorterPathIfPrefix(String path1, String path2) {
        List<String> fragments2;
        if (!path1.startsWith(path2) && !path2.startsWith(path1)) {
            return null;
        }
        List<String> fragments1 = Utils.splitPath(path1);
        List<String> commonFragments = Utils.collectCommonPathFragments(fragments1, fragments2 = Utils.splitPath(path2));
        if (commonFragments.size() != fragments1.size() && commonFragments.size() != fragments2.size()) {
            return null;
        }
        return Utils.joinPath(commonFragments);
    }

    public static List<String> collectCommonPathFragments(String path1, String path2) {
        List<String> fragments1 = Utils.splitPath(path1);
        List<String> fragments2 = Utils.splitPath(path2);
        return Utils.collectCommonPathFragments(fragments1, fragments2);
    }

    private static List<String> collectCommonPathFragments(List<String> fragments1, List<String> fragments2) {
        String fragment2;
        String fragment1;
        ArrayList<String> commonFragments = new ArrayList<String>();
        for (int i = 0; i < Math.min(fragments1.size(), fragments2.size()) && (fragment1 = fragments1.get(i)).equals(fragment2 = fragments2.get(i)); ++i) {
            commonFragments.add(fragment1);
        }
        return commonFragments;
    }

    static String getLastFragment(String path) {
        List<String> fragments = Utils.splitPath(path);
        return fragments.get(fragments.size() - 1);
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return e.toString();
        }
    }

    public static void copySubdocumentValue(Document input, Document result, String key) {
        Object value = Utils.getSubdocumentValueCollectionAware(input, key);
        if (!(value instanceof Missing)) {
            Utils.changeSubdocumentValue(result, key, value);
        }
    }
}

