/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Cursor;
import de.bwaldvogel.mongo.backend.EmptyCursor;
import de.bwaldvogel.mongo.bson.Document;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class QueryResult
implements Iterable<Document> {
    private final Iterable<Document> documents;
    private final long cursorId;

    public QueryResult() {
        this(Collections.emptyList(), EmptyCursor.get());
    }

    public QueryResult(Iterable<Document> documents, Cursor cursor) {
        this(documents, cursor.getId());
    }

    public QueryResult(Iterable<Document> documents, long cursorId) {
        this.documents = documents;
        this.cursorId = cursorId;
    }

    public QueryResult(Iterable<Document> documents) {
        this(documents, EmptyCursor.get());
    }

    public List<Document> collectDocuments() {
        if (this.documents instanceof List) {
            return Collections.unmodifiableList((List)this.documents);
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (Document document : this) {
            documents.add(document);
        }
        return documents;
    }

    @Override
    public Iterator<Document> iterator() {
        return this.documents.iterator();
    }

    public long getCursorId() {
        return this.cursorId;
    }
}

