/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.InvalidOptionsException;
import de.bwaldvogel.mongo.exception.MongoServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionOptions {
    private static final Logger log = LoggerFactory.getLogger(CollectionOptions.class);
    private static final String DEFAULT_ID_FIELD = "_id";
    private static final boolean DEFAULT_AUTO_INDEX_ID = true;
    private static final boolean DEFAULT_CAPPED = false;
    private static final long CAPPED_SIZE_GRANULARITY = 256L;
    private static final long MIN_CAPPED_SIZE = 256L;
    private final String idField;
    private final boolean autoIndexId;
    private final boolean capped;
    private final Long cappedSize;

    private CollectionOptions(String idField, boolean autoIndexId, boolean capped, Long cappedSize) {
        this.idField = idField;
        this.autoIndexId = autoIndexId;
        this.capped = capped;
        this.cappedSize = CollectionOptions.calculateCappedSize(cappedSize);
    }

    static Long calculateCappedSize(Long cappedSize) {
        if (cappedSize == null) {
            return null;
        }
        long value = cappedSize;
        if (value <= 256L) {
            log.info("Using minimum capped size of {} bytes", (Object)256L);
            return 256L;
        }
        long mod = value % 256L;
        if (mod == 0L) {
            return value;
        }
        long raisedCappedSize = value + (256L - mod);
        log.info("Raised capped size to {} bytes", (Object)raisedCappedSize);
        return raisedCappedSize;
    }

    public String getIdField() {
        return this.idField;
    }

    public static CollectionOptions withDefaults() {
        return CollectionOptions.withIdField(DEFAULT_ID_FIELD);
    }

    public static CollectionOptions withIdField(String idField) {
        return new CollectionOptions(idField, true, false, null);
    }

    public static CollectionOptions withoutIdField() {
        return CollectionOptions.withIdField(null);
    }

    public static CollectionOptions fromQuery(Document query) {
        boolean autoIndexId = CollectionOptions.toBoolean(query.get("autoIndexId"), true);
        boolean capped = CollectionOptions.toBoolean(query.get("capped"), false);
        Long cappedSize = CollectionOptions.toInt(query.get("size"));
        return new CollectionOptions(DEFAULT_ID_FIELD, autoIndexId, capped, cappedSize);
    }

    private static Long toInt(Object value) {
        if (value == null) {
            return null;
        }
        return ((Number)value).longValue();
    }

    private static boolean toBoolean(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Utils.isTrue(value);
    }

    public void validate() {
        if (!this.autoIndexId) {
            throw new MongoServerException("Disabling autoIndexId is not yet implemented");
        }
        if (this.capped) {
            if (this.cappedSize == null) {
                throw new InvalidOptionsException("the 'size' field is required when 'capped' is true");
            }
            throw new MongoServerException("Creating capped collections is not yet implemented");
        }
    }
}

