/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.ArrayFilters;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.QueryParameters;
import de.bwaldvogel.mongo.backend.QueryResult;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.oplog.NoopOplog;
import de.bwaldvogel.mongo.oplog.Oplog;
import java.util.List;
import java.util.Spliterator;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface MongoCollection<P> {
    public UUID getUuid();

    public MongoDatabase getDatabase();

    default public String getDatabaseName() {
        return this.getDatabase().getDatabaseName();
    }

    default public String getFullName() {
        return this.getDatabaseName() + "." + this.getCollectionName();
    }

    public String getCollectionName();

    public void addIndex(Index<P> var1);

    public void dropIndex(String var1);

    public void addDocument(Document var1);

    default public void addDocuments(Stream<Document> documents) {
        documents.forEach(this::addDocument);
    }

    public void removeDocument(Document var1);

    default public void addDocumentIfMissing(Document document) {
        if (!this.handleQuery(document, 0, 1).iterator().hasNext()) {
            this.addDocument(document);
        }
    }

    default public Iterable<Document> queryAll() {
        return this.handleQuery(new Document());
    }

    default public Stream<Document> queryAllAsStream() {
        Spliterator<Document> documents = this.queryAll().spliterator();
        return StreamSupport.stream(documents, false);
    }

    default public Iterable<Document> handleQuery(Document query) {
        return this.handleQuery(query, 0, 0);
    }

    default public Stream<Document> handleQueryAsStream(Document query) {
        Spliterator<Document> documents = this.handleQuery(query).spliterator();
        return StreamSupport.stream(documents, false);
    }

    default public QueryResult handleQuery(Document query, int numberToSkip, int limit) {
        return this.handleQuery(new QueryParameters(query, numberToSkip, limit));
    }

    public QueryResult handleQuery(QueryParameters var1);

    default public void insertDocuments(List<Document> documents) {
        this.insertDocuments(documents, true);
    }

    public List<Document> insertDocuments(List<Document> var1, boolean var2);

    public Document updateDocuments(Document var1, Document var2, ArrayFilters var3, boolean var4, boolean var5, Oplog var6);

    default public int deleteDocuments(Document selector, int limit) {
        return this.deleteDocuments(selector, limit, NoopOplog.get());
    }

    public int deleteDocuments(Document var1, int var2, Oplog var3);

    public Document handleDistinct(Document var1);

    public Document getStats();

    public Document validate();

    public Document findAndModify(Document var1);

    public int count(Document var1, int var2, int var3);

    default public boolean isEmpty() {
        return this.count() == 0;
    }

    public int count();

    default public int getNumIndexes() {
        return this.getIndexes().size();
    }

    public List<Index<P>> getIndexes();

    public void renameTo(MongoDatabase var1, String var2);

    public void drop();
}

