/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.request.resource.caching.version;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import java.util.zip.Checksum;
import org.apache.wicket.Application;
import org.apache.wicket.request.resource.caching.version.MessageDigestResourceVersion;
import org.apache.wicket.util.io.IOUtils;

public abstract class ChecksumResourceVersion
extends MessageDigestResourceVersion {
    private static final Pattern NON_PRINTABLE = Pattern.compile("[\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]");

    protected abstract Checksum newChecksumBuilder();

    protected Charset charset() {
        String charset;
        if (Application.exists() && !Strings.isNullOrEmpty((String)(charset = Application.get().getMarkupSettings().getDefaultMarkupEncoding()))) {
            return Charset.forName(charset);
        }
        return Charsets.UTF_8;
    }

    protected int bufferSize() {
        return 1024;
    }

    protected byte[] computeDigest(InputStream inputStream) throws IOException {
        Checksum checksum = this.newChecksumBuilder();
        byte[] bytes = new byte[this.bufferSize()];
        try {
            int len;
            while ((len = inputStream.read(bytes)) >= 0) {
                checksum.update(bytes, 0, len);
            }
        }
        catch (RuntimeException e) {
            checksum.reset();
            throw e;
        }
        finally {
            IOUtils.close((Closeable)inputStream);
        }
        return this.stripNonVisibleChars(Long.toHexString(checksum.getValue())).getBytes(this.charset());
    }

    private String stripNonVisibleChars(String checksum) {
        return NON_PRINTABLE.matcher(checksum).replaceAll("");
    }
}

