/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.navigation;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.IPagingLabelProvider;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigation;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;

public class BootstrapPagingNavigator
extends PagingNavigator {
    private Size size;

    public BootstrapPagingNavigator(String markupId, IPageable pageable) {
        this(markupId, pageable, null);
    }

    public BootstrapPagingNavigator(String markupId, IPageable pageable, IPagingLabelProvider labelProvider) {
        super(markupId, pageable, labelProvider);
        BootstrapBaseBehavior.addTo((Component)this);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "ul");
        Attributes.addClass(tag, "pagination");
        if (this.size != null && !this.size.equals((Object)Size.Default)) {
            Attributes.addClass(tag, this.size.cssClass());
        }
    }

    protected PagingNavigation newNavigation(String id, IPageable pageable, IPagingLabelProvider labelProvider) {
        return new PagingNavigation(id, pageable, labelProvider){
            private final AttributeModifier activeAttribute;
            {
                this.activeAttribute = AttributeModifier.append((String)"class", (Serializable)((Object)"active"));
            }

            protected void populateItem(LoopItem loopItem) {
                super.populateItem(loopItem);
                if (this.getStartIndex() + (long)loopItem.getIndex() == this.pageable.getCurrentPage()) {
                    loopItem.add(new Behavior[]{this.activeAttribute});
                }
            }
        };
    }

    public BootstrapPagingNavigator setSize(Size size) {
        this.size = Size.Default.equals((Object)size) ? null : size;
        return this;
    }

    public static enum Size {
        Small("sm"),
        Default(""),
        Large("lg");

        private final String size;

        private Size(String size) {
            this.size = size;
        }

        public String cssClass() {
            return this.equals((Object)Default) ? "" : "pagination-" + this.size;
        }
    }
}

