/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonList;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.util.Attributes;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.lang.Args;

public abstract class ButtonGroup
extends Panel {
    private static final long serialVersionUID = 1L;
    private final Buttons.Orientation orientation;
    private final Size size;

    public ButtonGroup(String markupId) {
        this(markupId, Buttons.Orientation.Horizontal, Size.Default);
    }

    public ButtonGroup(String markupId, Buttons.Orientation orientation) {
        this(markupId, orientation, Size.Default);
    }

    public ButtonGroup(String markupId, Buttons.Orientation orientation, Size size) {
        super(markupId);
        Args.notNull((Object)orientation, (String)"orientation");
        this.orientation = orientation;
        this.size = size;
        BootstrapBaseBehavior.addTo((Component)this);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.newButtonList("buttons")});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Attributes.addClass(tag, this.orientation.cssClassName(), "btn-group");
        if (!Size.Default.equals((Object)this.size)) {
            Attributes.addClass(tag, "btn-group-" + this.size.cssName);
        }
    }

    protected ButtonList newButtonList(String markupId) {
        ButtonList buttonList = new ButtonList(markupId, this.newButtons(ButtonList.getButtonMarkupId()));
        buttonList.setRenderBodyOnly(true);
        return buttonList;
    }

    protected abstract List<AbstractLink> newButtons(String var1);

    public static enum Size {
        ExtraSmall("xs"),
        Small("sm"),
        Default(""),
        Large("lg");

        private final String cssName;

        private Size(String cssName) {
            this.cssName = cssName;
        }
    }
}

