/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.settings.BootstrapResourceAppender;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.jquery.WicketJquerySelectors;
import de.agilecoders.wicket.webjars.WicketWebjars;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.markup.html.SecurePackageResourceGuard;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.IMarkupSettings;
import org.apache.wicket.util.lang.Args;

public final class Bootstrap {
    private static final MetaDataKey<IBootstrapSettings> BOOTSTRAP_SETTINGS_METADATA_KEY = new MetaDataKey<IBootstrapSettings>(){};

    private Bootstrap() {
        throw new UnsupportedOperationException();
    }

    public static void install(Application app, IBootstrapSettings settings) {
        Args.notNull((Object)app, (String)"app");
        if (Bootstrap.getSettings(app) == null) {
            if (settings == null) {
                settings = new BootstrapSettings();
            }
            app.setMetaData(BOOTSTRAP_SETTINGS_METADATA_KEY, (Object)settings);
            if (!WicketJquerySelectors.isInstalled((Application)app)) {
                WicketJquerySelectors.install((Application)app);
            }
            if (settings.useWebjars() && app instanceof WebApplication) {
                WicketWebjars.install((WebApplication)((WebApplication)app));
            }
            if (settings.updateSecurityManager()) {
                Bootstrap.updateSecurityManager(app);
            }
            if (settings.autoAppendResources()) {
                app.getComponentInstantiationListeners().add((Object)new BootstrapResourceAppender());
            }
            Bootstrap.configureMarkupSettings(app);
        }
    }

    public static void install(Application app) {
        Bootstrap.install(app, null);
    }

    private static void configureMarkupSettings(Application application) {
        IMarkupSettings markupSettings = application.getMarkupSettings();
        markupSettings.setStripWicketTags(true);
    }

    private static void updateSecurityManager(Application app) {
        IPackageResourceGuard packageResourceGuard = app.getResourceSettings().getPackageResourceGuard();
        if (packageResourceGuard instanceof SecurePackageResourceGuard) {
            SecurePackageResourceGuard guard = (SecurePackageResourceGuard)packageResourceGuard;
            guard.addPattern("+*.woff");
            guard.addPattern("+*.eot");
            guard.addPattern("+*.svg");
            guard.addPattern("+*.ttf");
            guard.addPattern("+*.css.map");
        }
    }

    public static IBootstrapSettings getSettings(Application app) {
        return (IBootstrapSettings)((Application)Args.notNull((Object)app, (String)"app")).getMetaData(BOOTSTRAP_SETTINGS_METADATA_KEY);
    }

    public static IBootstrapSettings getSettings() {
        if (Application.exists()) {
            return Bootstrap.getSettings(Application.get());
        }
        throw new IllegalStateException("there is no active application assigned to this thread.");
    }

    public static void renderHead(Component component, IHeaderResponse response) {
        Args.notNull((Object)component, (String)"component");
        Args.notNull((Object)response, (String)"response");
        BootstrapResourcesBehavior.instance().renderHead(Bootstrap.getSettings(component.getApplication()), response);
    }

    public static void renderHead(IHeaderResponse response) {
        Args.notNull((Object)response, (String)"response");
        BootstrapResourcesBehavior.instance().renderHead(Bootstrap.getSettings(Application.get()), response);
    }
}

