/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.ysql.ClusterAwareLoadBalancer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class TopologyAwareLoadBalancer
extends ClusterAwareLoadBalancer {
    private final String placements;
    private final Set<CloudPlacement> allowedPlacements;

    public TopologyAwareLoadBalancer(String placementvalues) {
        this.placements = placementvalues;
        this.allowedPlacements = new HashSet<CloudPlacement>();
        this.populatePlacementSet();
    }

    @Override
    protected String loadBalancingNodes() {
        return this.placements;
    }

    private void populatePlacementSet() {
        String[] placementstrings;
        for (String pl : placementstrings = this.placements.split(",")) {
            String[] placementParts = pl.split("\\.");
            if (placementParts.length != 3) {
                LOGGER.log(Level.WARNING, this.getLoadBalancerType() + ": Ignoring malformed topology-key property value: " + pl);
                continue;
            }
            CloudPlacement cp = new CloudPlacement(placementParts[0], placementParts[1], placementParts[2]);
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Adding placement " + cp + " to allowed list");
            this.allowedPlacements.add(cp);
        }
    }

    @Override
    protected void updateCurrentHostList(ArrayList<String> currentPrivateIps, String host, String publicIp, String cloud, String region, String zone) {
        CloudPlacement cp = new CloudPlacement(cloud, region, zone);
        if (this.allowedPlacements.contains(cp)) {
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": allowedPlacements set: " + this.allowedPlacements + " returned contains true for cp: " + cp);
            currentPrivateIps.add(host);
            if (!publicIp.trim().isEmpty()) {
                this.currentPublicIps.add(publicIp);
            }
        } else {
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": allowedPlacements set: " + this.allowedPlacements + " returned contains false for cp: " + cp);
        }
    }

    @Override
    protected String getLoadBalancerType() {
        return "TopologyAwareLoadBalancer";
    }

    static class CloudPlacement {
        private final String cloud;
        private final String region;
        private final String zone;

        CloudPlacement(String cloud, String region, String zone) {
            this.cloud = cloud;
            this.region = region;
            this.zone = zone;
        }

        public int hashCode() {
            return this.cloud.hashCode() ^ this.region.hashCode() ^ this.zone.hashCode();
        }

        public boolean equals(Object other) {
            boolean equal = false;
            ClusterAwareLoadBalancer.LOGGER.log(Level.FINE, "equals called for this: " + this + " and other = " + other);
            if (other instanceof CloudPlacement) {
                CloudPlacement o = (CloudPlacement)other;
                equal = this.cloud.equalsIgnoreCase(o.cloud) && this.region.equalsIgnoreCase(o.region) && this.zone.equalsIgnoreCase(o.zone);
            }
            ClusterAwareLoadBalancer.LOGGER.log(Level.FINE, "equals returning: " + equal);
            return equal;
        }

        public String toString() {
            return "Placement: " + this.cloud + "." + this.region + "." + this.zone;
        }
    }
}

