/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.config.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Maps;
import java.util.Map;

public enum CertStoreType {
    STRING("string", "\u660e\u6587"),
    FILE_CER("file_cer", "\u516c\u94a5\u8bc1\u4e66\u6587\u4ef6"),
    FILE_P12("file_p12", "\u6587\u4ef6");

    private static final Map<String, CertStoreType> VALUE_MAP;
    private final String value;
    private final String displayName;

    private CertStoreType(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    @JsonCreator
    public static CertStoreType parse(String value) {
        return VALUE_MAP.get(value);
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Map<String, CertStoreType> getValueMap() {
        return VALUE_MAP;
    }

    static {
        VALUE_MAP = Maps.newHashMap();
        for (CertStoreType item : CertStoreType.values()) {
            VALUE_MAP.put(item.value, item);
        }
    }
}

