/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.auth.req;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.req.AuthorizationReq;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.SignerTypeEnum;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AuthorizationReqSupport {
    private static final Map<String, AuthorizationReq> SUPPORTED_AUTH_REQS = Maps.newHashMap();
    private static final List<AuthorizationReq> DEFAULT_AUTH_REQS_FOR_API = Lists.newArrayList();

    public static AuthorizationReq getAuthorizationReq(String securityReq) {
        return SUPPORTED_AUTH_REQS.get(securityReq);
    }

    public static List<AuthorizationReq> getDefaultAuthReqsForApi() {
        return Collections.unmodifiableList(DEFAULT_AUTH_REQS_FOR_API);
    }

    public static AuthorizationReq buildAuthorizationReq(String signerType, String credentialType, String signatureAlg, DigestAlgEnum digestAlg, String protocolPrefix) {
        return AuthorizationReq.Builder.anAuthorizationReq().withSignerType(signerType).withCredentialType(credentialType).withSignatureAlg(signatureAlg).withDigestAlg(digestAlg).withProtocolPrefix(protocolPrefix).build();
    }

    static {
        AuthorizationReq sm2AuthReq = AuthorizationReqSupport.buildAuthorizationReq(SignerTypeEnum.SM2.name(), "SM2", "SM3withSM2", DigestAlgEnum.SM3, "YOP-SM2-SM3");
        AuthorizationReq rsaAuthReq = AuthorizationReqSupport.buildAuthorizationReq(SignerTypeEnum.RSA.name(), "RSA2048", "SHA256withRSA", DigestAlgEnum.SHA256, "YOP-RSA2048-SHA256");
        SUPPORTED_AUTH_REQS.put("YOP-SM2-SM3", sm2AuthReq);
        SUPPORTED_AUTH_REQS.put("YOP-RSA2048-SHA256", rsaAuthReq);
        DEFAULT_AUTH_REQS_FOR_API.add(sm2AuthReq);
        DEFAULT_AUTH_REQS_FOR_API.add(rsaAuthReq);
        SUPPORTED_AUTH_REQS.put("YOP-OAUTH2", AuthorizationReqSupport.buildAuthorizationReq(SignerTypeEnum.OAUTH2.name(), "TOKEN", null, DigestAlgEnum.SHA256, "Bearer"));
    }
}

