/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.impl.LogUtils;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class VespaFormat {
    private static final Pattern special = Pattern.compile("[\r\\\n\\\t\\\\]+");
    private static final Pattern newLine = Pattern.compile("\n");
    private static final Pattern carriage = Pattern.compile("\r");
    private static final Pattern tab = Pattern.compile("\t");
    private static final Pattern backSlash = Pattern.compile("\\\\");
    private static final String hostname = LogUtils.getHostName();
    private static final String processID = LogUtils.getPID();

    VespaFormat() {
    }

    public static String escape(String s) {
        if (s == null) {
            return "(empty)";
        }
        Matcher m = special.matcher(s);
        if (!m.find()) {
            return s;
        }
        m = backSlash.matcher(s);
        if (m.find()) {
            s = m.replaceAll("\\\\\\\\");
        }
        if ((m = newLine.matcher(s)).find()) {
            s = m.replaceAll("\\\\n");
        }
        if ((m = carriage.matcher(s)).find()) {
            s = m.replaceAll("\\\\r");
        }
        if ((m = tab.matcher(s)).find()) {
            s = m.replaceAll("\\\\t");
        }
        return s;
    }

    public static String formatTime(Instant instant) {
        return String.format("%d.%06d", instant.getEpochSecond(), instant.getNano() / 1000);
    }

    static String formatThreadProcess(long processId, long threadId) {
        if (threadId == 0L) {
            return Long.toString(processId);
        }
        return processId + "/" + threadId;
    }
}

