/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.log;

import com.yahoo.log.LevelController;
import com.yahoo.log.LogLevel;
import com.yahoo.log.impl.LogUtils;
import java.util.logging.Level;

class DefaultLevelController
implements LevelController {
    private String levelstring;
    private Level levelLimit = LogLevel.EVENT;

    DefaultLevelController(String env) {
        if (LogUtils.empty(env)) {
            env = "all -debug -spam";
        }
        if (env.equals("all")) {
            this.levelLimit = LogLevel.ALL;
            this.levelstring = "  ON  ON  ON  ON  ON  ON  ON  ON";
        } else {
            StringBuilder sb = new StringBuilder();
            for (Level level : LogLevel.getLevels().values()) {
                String levelName = level.getName();
                if (this.hasNegWord(levelName, env) || !this.hasWord("all", env) && !this.hasWord(levelName, env)) {
                    sb.append(" OFF");
                    continue;
                }
                sb.append("  ON");
                if (level.intValue() >= this.levelLimit.intValue()) continue;
                this.levelLimit = level;
            }
            this.levelstring = sb.toString();
        }
    }

    private boolean hasWord(String levelName, String inputLevels) {
        return inputLevels.contains(levelName.toLowerCase());
    }

    private boolean hasNegWord(String levelName, String inputLevels) {
        int pos = inputLevels.indexOf(levelName.toLowerCase());
        if (pos > 0) {
            String c = inputLevels.substring(pos - 1, pos);
            return c != null && c.equals("-");
        }
        return false;
    }

    @Override
    public String getOnOffString() {
        return this.levelstring;
    }

    @Override
    public Level getLevelLimit() {
        return this.levelLimit;
    }

    @Override
    public boolean shouldLog(Level level) {
        return level.intValue() >= this.levelLimit.intValue();
    }

    @Override
    public void checkBack() {
    }
}

