/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.concurrent;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Supplier;

public final class ResourcePool<T>
implements Iterable<T> {
    private final Deque<T> pool = new ArrayDeque<T>();
    private final Supplier<T> factory;

    public ResourcePool(Supplier<T> factory) {
        this.factory = factory;
    }

    public T alloc() {
        return this.pool.isEmpty() ? this.factory.get() : this.pool.pop();
    }

    public void free(T e) {
        this.pool.push(e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.pool.iterator();
    }
}

