/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.net;

import com.yahoo.net.Url;
import com.yahoo.net.UrlToken;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UrlTokenizer {
    public static final String TERM_STARTHOST = "StArThOsT";
    public static final String TERM_ENDHOST = "EnDhOsT";
    private static final Map<String, String> schemeToPort = new HashMap<String, String>();
    private static final Map<String, String> portToScheme = new HashMap<String, String>();
    private static final char TO_LOWER = '\uffe0';
    private final Url url;

    public UrlTokenizer(String url) {
        this(Url.fromString(url));
    }

    public UrlTokenizer(Url url) {
        this.url = url;
    }

    private String guessScheme(String port) {
        String scheme = portToScheme.get(port);
        if (scheme != null) {
            return scheme;
        }
        return "http";
    }

    private String guessPort(String scheme) {
        String port = schemeToPort.get(scheme);
        if (port != null) {
            return port;
        }
        return null;
    }

    public List<UrlToken> tokenize() {
        String fragment;
        String query;
        String path;
        String host;
        String password;
        LinkedList<UrlToken> lst = new LinkedList<UrlToken>();
        int offset = 0;
        String port = this.url.getPortString();
        String scheme = this.url.getScheme();
        if (scheme == null) {
            scheme = this.guessScheme(port);
            UrlTokenizer.addTokens(lst, UrlToken.Type.SCHEME, offset, scheme, false);
        } else {
            UrlTokenizer.addTokens(lst, UrlToken.Type.SCHEME, this.url.getSchemeBegin(), scheme, true);
            offset = this.url.getSchemeEnd();
        }
        String userInfo = this.url.getUserInfo();
        if (userInfo != null) {
            UrlTokenizer.addTokens(lst, UrlToken.Type.USERINFO, this.url.getUserInfoBegin(), userInfo, true);
            offset = this.url.getUserInfoEnd();
        }
        if ((password = this.url.getPassword()) != null) {
            UrlTokenizer.addTokens(lst, UrlToken.Type.PASSWORD, this.url.getPasswordBegin(), password, true);
            offset = this.url.getPasswordEnd();
        }
        if ((host = this.url.getHost()) == null || host.isEmpty()) {
            if (host != null) {
                offset = this.url.getHostBegin();
            }
            if ("file".equalsIgnoreCase(scheme)) {
                UrlTokenizer.addHostTokens(lst, offset, offset, "localhost", false);
            }
        } else {
            UrlTokenizer.addHostTokens(lst, this.url.getHostBegin(), this.url.getHostEnd(), host, true);
            offset = this.url.getHostEnd();
        }
        if ((port = this.url.getPortString()) == null) {
            port = this.guessPort(scheme);
            if (port != null) {
                UrlTokenizer.addTokens(lst, UrlToken.Type.PORT, offset, port, false);
            }
        } else {
            UrlTokenizer.addTokens(lst, UrlToken.Type.PORT, this.url.getPortBegin(), port, true);
        }
        if ((path = this.url.getPath()) != null) {
            UrlTokenizer.addTokens(lst, UrlToken.Type.PATH, this.url.getPathBegin(), path, true);
        }
        if ((query = this.url.getQuery()) != null) {
            UrlTokenizer.addTokens(lst, UrlToken.Type.QUERY, this.url.getQueryBegin(), query, true);
        }
        if ((fragment = this.url.getFragment()) != null) {
            UrlTokenizer.addTokens(lst, UrlToken.Type.FRAGMENT, this.url.getFragmentBegin(), fragment, true);
        }
        return lst;
    }

    public static void addTokens(List<UrlToken> lst, UrlToken.Type type, int offset, String image, boolean orig) {
        int skip;
        StringBuilder term = new StringBuilder();
        int prev = 0;
        int len = image.length();
        for (int next = 0; next < len; next += skip) {
            char c = image.charAt(next);
            if (c == '%') {
                c = (char)Integer.parseInt(image.substring(next + 1, next + 3), 16);
                skip = 3;
            } else {
                skip = 1;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '-' || c == '_') {
                term.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                term.append((char)(c - 65504));
                continue;
            }
            if (prev < next) {
                lst.add(new UrlToken(type, offset + (orig ? prev : 0), orig ? image.substring(prev, next) : null, term.toString()));
                term = new StringBuilder();
            }
            prev = next + skip;
        }
        if (term.length() > 0) {
            lst.add(new UrlToken(type, offset + (orig ? prev : 0), orig ? image.substring(prev) : null, term.toString()));
        }
    }

    private static void addHostTokens(List<UrlToken> lst, int begin, int end, String image, boolean orig) {
        lst.add(new UrlToken(UrlToken.Type.HOST, begin, null, TERM_STARTHOST));
        UrlTokenizer.addTokens(lst, UrlToken.Type.HOST, begin, image, orig);
        lst.add(new UrlToken(UrlToken.Type.HOST, end, null, TERM_ENDHOST));
    }

    private static void registerScheme(String scheme, int port) {
        String str = String.valueOf(port);
        schemeToPort.put(scheme, str);
        portToScheme.put(str, scheme);
    }

    static {
        UrlTokenizer.registerScheme("ftp", 21);
        UrlTokenizer.registerScheme("gopher", 70);
        UrlTokenizer.registerScheme("http", 80);
        UrlTokenizer.registerScheme("https", 443);
        UrlTokenizer.registerScheme("imap", 143);
        UrlTokenizer.registerScheme("mailto", 25);
        UrlTokenizer.registerScheme("news", 119);
        UrlTokenizer.registerScheme("nntp", 119);
        UrlTokenizer.registerScheme("pop", 110);
        UrlTokenizer.registerScheme("rsync", 873);
        UrlTokenizer.registerScheme("rtsp", 554);
        UrlTokenizer.registerScheme("sftp", 22);
        UrlTokenizer.registerScheme("shttp", 443);
        UrlTokenizer.registerScheme("sip", 5060);
        UrlTokenizer.registerScheme("sips", 5061);
        UrlTokenizer.registerScheme("snmp", 161);
        UrlTokenizer.registerScheme("ssh", 22);
        UrlTokenizer.registerScheme("telnet", 23);
        UrlTokenizer.registerScheme("tftp", 69);
    }
}

