/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import com.yahoo.collections.Pair;
import com.yahoo.concurrent.CopyOnWriteHashMap;
import java.lang.reflect.Method;
import java.util.function.Consumer;

public final class MethodCache {
    private final String methodName;
    private final CopyOnWriteHashMap<String, Pair<Class<?>, Method>> cache = new CopyOnWriteHashMap();

    public MethodCache(String methodName) {
        this.methodName = methodName;
    }

    public void clear() {
        this.cache.clear();
    }

    public Method get(Object object) {
        return this.get(object, null);
    }

    public Method get(Object object, Consumer<String> onPut) {
        Method method;
        Pair<Class<?>, Method> pair = this.cache.get(object.getClass().getName());
        if (pair != null && pair.getFirst() != object.getClass()) {
            this.cache.clear();
            pair = null;
        }
        Method method2 = method = pair == null ? null : pair.getSecond();
        if (pair == null) {
            method = this.lookupMethod(object);
            this.cache.put(object.getClass().getName(), new Pair(object.getClass(), method));
            if (onPut != null) {
                onPut.accept(object.getClass().getName());
            }
        }
        return method;
    }

    private Method lookupMethod(Object object) {
        try {
            return object.getClass().getMethod(this.methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

