/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.http;

import ai.vespa.validation.PatternedStringWrapper;
import ai.vespa.validation.Validation;
import java.util.Optional;
import java.util.regex.Pattern;

public class DomainName
extends PatternedStringWrapper<DomainName> {
    protected static final Pattern labelPattern = Pattern.compile("([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])");
    protected static final Pattern domainNamePattern = Pattern.compile("(" + String.valueOf(labelPattern) + "\\.)*" + String.valueOf(labelPattern) + "\\.?");
    public static final DomainName localhost = DomainName.of("localhost");

    protected DomainName(String value, String description) {
        super(Validation.requireLength(value, "domain name length", 1, 255), domainNamePattern, description);
    }

    public static DomainName of(String value) {
        return new DomainName(value, "domain name");
    }

    public static String requireLabel(String label) {
        return Validation.requireMatch(label, "domain name label", labelPattern);
    }

    public String leafLabel() {
        int offset = this.value().indexOf(46);
        return offset == -1 ? this.value() : this.value().substring(0, offset);
    }

    public Optional<DomainName> parent() {
        int offset = this.value().indexOf(46);
        if (offset == -1 || offset == this.value().length() - 1) {
            return Optional.empty();
        }
        return Optional.of(DomainName.of(this.value().substring(offset + 1)));
    }
}

