/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import java.util.BitSet;

public class Ascii7BitMatcher {
    private final BitSet legalFirst;
    private final BitSet legalRest;

    private static BitSet createBitSet(String legal) {
        BitSet legalChars = new BitSet(128);
        for (int i = 0; i < legal.length(); ++i) {
            char c = legal.charAt(i);
            if (c >= '\u0080') {
                throw new IllegalArgumentException("Char '" + c + "' at position " + i + " is not valid ascii 7 bit char");
            }
            legalChars.set(c);
        }
        return legalChars;
    }

    public Ascii7BitMatcher(String legal) {
        this(legal, legal);
    }

    public Ascii7BitMatcher(String legalFirstChar, String legalChars) {
        this.legalFirst = Ascii7BitMatcher.createBitSet(legalFirstChar);
        this.legalRest = Ascii7BitMatcher.createBitSet(legalChars);
    }

    private static boolean isAscii7Bit(char c) {
        return c < '\u0080';
    }

    private boolean isLegalFirst(char c) {
        return Ascii7BitMatcher.isAscii7Bit(c) && this.legalFirst.get(c);
    }

    private boolean isLegalRest(char c) {
        return Ascii7BitMatcher.isAscii7Bit(c) && this.legalRest.get(c);
    }

    public boolean matches(String s) {
        if (s == null || s.isEmpty() || !this.isLegalFirst(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (this.isLegalRest(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String charsAndNumbers() {
        int c;
        char[] chars = new char[62];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            chars[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            chars[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            chars[i++] = c;
        }
        return new String(chars);
    }
}

