/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.compress;

import io.airlift.compress.Compressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.util.Arrays;

public class ZstdCompressor {
    private io.airlift.compress.zstd.ZstdCompressor compressor = new io.airlift.compress.zstd.ZstdCompressor();
    private ZstdDecompressor decompressor = new ZstdDecompressor();
    private static final Compressor threadUnsafe = new io.airlift.compress.zstd.ZstdCompressor();

    public byte[] compress(byte[] input, int inputOffset, int inputLength) {
        int maxCompressedLength = ZstdCompressor.getMaxCompressedLength(inputLength);
        byte[] output = new byte[maxCompressedLength];
        int compressedLength = this.compress(input, inputOffset, inputLength, output, 0, maxCompressedLength);
        return Arrays.copyOf(output, compressedLength);
    }

    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        return this.compressor.compress(input, inputOffset, inputLength, output, outputOffset, maxOutputLength);
    }

    public byte[] decompress(byte[] input, int inputOffset, int inputLength) {
        int decompressedLength = ZstdCompressor.getDecompressedLength(input, inputOffset, inputLength);
        byte[] output = new byte[decompressedLength];
        this.decompress(input, inputOffset, inputLength, output, 0, decompressedLength);
        return output;
    }

    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        return this.decompressor.decompress(input, inputOffset, inputLength, output, outputOffset, maxOutputLength);
    }

    public static int getMaxCompressedLength(int uncompressedLength) {
        return threadUnsafe.maxCompressedLength(uncompressedLength);
    }

    public static int getDecompressedLength(byte[] input, int inputOffset, int inputLength) {
        return (int)ZstdDecompressor.getDecompressedSize((byte[])input, (int)inputOffset, (int)inputLength);
    }
}

