/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.http;

import ai.vespa.http.DomainName;
import ai.vespa.validation.Validation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class HttpURL {
    private final Scheme scheme;
    private final DomainName domain;
    private final int port;
    private final Path path;
    private final Query query;

    private HttpURL(Scheme scheme, DomainName domain, int port, Path path, Query query) {
        this.scheme = Objects.requireNonNull(scheme);
        this.domain = Objects.requireNonNull(domain);
        this.port = Validation.requireInRange(port, "port number", -1, 65535);
        this.path = Objects.requireNonNull(path);
        this.query = Objects.requireNonNull(query);
    }

    public static HttpURL create(Scheme scheme, DomainName domain, int port, Path path, Query query) {
        return new HttpURL(scheme, domain, port, path, query);
    }

    public static HttpURL create(Scheme scheme, DomainName domain, int port, Path path) {
        return HttpURL.create(scheme, domain, port, path, Query.empty());
    }

    public static HttpURL create(Scheme scheme, DomainName domain, int port) {
        return HttpURL.create(scheme, domain, port, Path.empty(), Query.empty());
    }

    public static HttpURL create(Scheme scheme, DomainName domain) {
        return HttpURL.create(scheme, domain, -1);
    }

    public static HttpURL from(URI uri) {
        return HttpURL.from(uri, HttpURL::requirePathSegment, HttpURL::requireNothing);
    }

    public static HttpURL from(URI uri, Consumer<String> pathValidator, Consumer<String> queryValidator) {
        if (!uri.normalize().equals(uri)) {
            throw new IllegalArgumentException("uri should be normalized, but got: " + String.valueOf(uri));
        }
        return HttpURL.create(Scheme.of(uri.getScheme()), DomainName.of(Objects.requireNonNull(uri.getHost(), "URI must specify a host")), uri.getPort(), Path.parse(uri.getRawPath(), pathValidator), Query.parse(uri.getRawQuery(), queryValidator));
    }

    public HttpURL withScheme(Scheme scheme) {
        return HttpURL.create(scheme, this.domain, this.port, this.path, this.query);
    }

    public HttpURL withDomain(DomainName domain) {
        return HttpURL.create(this.scheme, domain, this.port, this.path, this.query);
    }

    public HttpURL withPort(int port) {
        return HttpURL.create(this.scheme, this.domain, port, this.path, this.query);
    }

    public HttpURL withoutPort() {
        return HttpURL.create(this.scheme, this.domain, -1, this.path, this.query);
    }

    public HttpURL withPath(Path path) {
        return HttpURL.create(this.scheme, this.domain, this.port, path, this.query);
    }

    public HttpURL appendPath(Path path) {
        return HttpURL.create(this.scheme, this.domain, this.port, this.path.append(path), this.query);
    }

    public HttpURL withQuery(Query query) {
        return HttpURL.create(this.scheme, this.domain, this.port, this.path, query);
    }

    public HttpURL appendQuery(Query query) {
        return HttpURL.create(this.scheme, this.domain, this.port, this.path, this.query.add(query.entries()));
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public DomainName domain() {
        return this.domain;
    }

    public OptionalInt port() {
        return this.port == -1 ? OptionalInt.empty() : OptionalInt.of(this.port);
    }

    public Path path() {
        return this.path;
    }

    public Query query() {
        return this.query;
    }

    public URI asURI() {
        try {
            return new URI(this.scheme.name() + "://" + this.domain.value() + (String)(this.port == -1 ? "" : ":" + this.port) + this.path.raw() + this.query.raw());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("invalid URI, this should not happen", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpURL httpURL = (HttpURL)o;
        return this.port == httpURL.port && this.scheme == httpURL.scheme && this.domain.equals(httpURL.domain) && this.path.equals(httpURL.path) && this.query.equals(httpURL.query);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scheme, this.domain, this.port, this.path, this.query});
    }

    public String toString() {
        return this.asURI().toString();
    }

    public static String requirePathSegment(String value) {
        while (!value.equals(value = URLDecoder.decode(value, StandardCharsets.UTF_8))) {
        }
        Validation.require(!value.contains("/"), value, "path segment decoded cannot contain '/'");
        Validation.require(!value.contains("?"), value, "path segment decoded cannot contain '?'");
        Validation.require(!value.contains("#"), value, "path segment decoded cannot contain '#'");
        return Path.requireNonNormalizable(value);
    }

    private static void requireNothing(String value) {
    }

    public static enum Scheme {
        http,
        https;


        public static Scheme of(String scheme) {
            if (scheme.equalsIgnoreCase(http.name())) {
                return http;
            }
            if (scheme.equalsIgnoreCase(https.name())) {
                return https;
            }
            throw new IllegalArgumentException("scheme must be HTTP or HTTPS");
        }
    }

    public static class Path {
        private static final Path empty = Path.empty(HttpURL::requirePathSegment);
        private final Node head;
        private final int length;
        private final boolean trailingSlash;
        private final UnaryOperator<String> validator;

        private Path(Node head, int length, boolean trailingSlash, UnaryOperator<String> validator) {
            this.head = head;
            this.length = length;
            this.trailingSlash = trailingSlash;
            this.validator = Objects.requireNonNull(validator);
        }

        public static Path empty() {
            return empty;
        }

        public static Path empty(Consumer<String> validator) {
            return new Path(null, 0, true, Path.segmentValidator(validator));
        }

        public static Path parse(String raw) {
            return Path.parse(raw, HttpURL::requirePathSegment);
        }

        public static Path parse(String raw, Consumer<String> validator) {
            Path path = new Path(null, 0, raw.endsWith("/"), Path.segmentValidator(validator));
            if (raw.startsWith("/")) {
                raw = raw.substring(1);
            }
            if (raw.isEmpty()) {
                return path;
            }
            for (String segment : raw.split("/")) {
                path = path.append(URLDecoder.decode(segment, StandardCharsets.UTF_8));
            }
            if (path.length == 0) {
                Path.requireNonNormalizable("");
            }
            return path;
        }

        private static UnaryOperator<String> segmentValidator(Consumer<String> validator) {
            Objects.requireNonNull(validator, "segment validator cannot be null");
            return value -> {
                Path.requireNonNormalizable(value);
                validator.accept((String)value);
                return value;
            };
        }

        private static String requireNonNormalizable(String segment) {
            return Validation.require(!segment.isEmpty() && !segment.equals(".") && !segment.equals(".."), segment, "path segments cannot be \"\", \".\", or \"..\"");
        }

        public Path head(int count) {
            Validation.requireInRange(count, "head count", 0, this.length);
            Node node = this.head;
            for (int i = count; i < this.length; ++i) {
                node = node.next;
            }
            return new Path(node, count, true, this.validator);
        }

        public Path tail(int count) {
            Validation.requireInRange(count, "tail count", 0, this.length);
            return count == this.length ? this : new Path(this.head, count, this.trailingSlash, this.validator);
        }

        public Path skip(int count) {
            Validation.requireInRange(count, "skip count", 0, this.length);
            return count == 0 ? this : new Path(this.head, this.length - count, this.trailingSlash, this.validator);
        }

        public Path cut(int count) {
            Validation.requireInRange(count, "cut count", 0, this.length);
            Node node = this.head;
            for (int i = 0; i < count; ++i) {
                node = node.next;
            }
            return new Path(node, this.length - count, true, this.validator);
        }

        public Path append(String segment) {
            return this.append(List.of(segment), this.trailingSlash);
        }

        public Path append(Path other) {
            return this.append(other.segments(), other.trailingSlash);
        }

        public Path append(List<String> segments) {
            return this.append(segments, this.trailingSlash);
        }

        private Path append(Iterable<String> segments, boolean trailingSlash) {
            Node node = this.head;
            int count = 0;
            for (String segment : segments) {
                node = new Node(node, (String)this.validator.apply(segment));
                ++count;
            }
            return new Path(node, this.length + count, trailingSlash, this.validator);
        }

        public boolean hasTrailingSlash() {
            return this.trailingSlash;
        }

        public Path withTrailingSlash() {
            return new Path(this.head, this.length, true, this.validator);
        }

        public Path withoutTrailingSlash() {
            return new Path(this.head, this.length, false, this.validator);
        }

        public List<String> segments() {
            ArrayList<String> list = new ArrayList<String>(this.length);
            for (int i = 0; i < this.length; ++i) {
                list.add(null);
            }
            Node node = this.head;
            int i = this.length;
            while (i-- > 0) {
                list.set(i, node.value);
                node = node.next;
            }
            return list;
        }

        public int length() {
            return this.length;
        }

        private String raw() {
            StringJoiner joiner = new StringJoiner("/", "/", this.trailingSlash ? "/" : "").setEmptyValue(this.trailingSlash ? "/" : "");
            for (String segment : this.segments()) {
                joiner.add(URLEncoder.encode(segment, StandardCharsets.UTF_8));
            }
            return joiner.toString();
        }

        public String toString() {
            return "path '" + this.raw() + "'";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return this.trailingSlash == path.trailingSlash && this.segments().equals(path.segments());
        }

        public int hashCode() {
            return Objects.hash(this.segments(), this.trailingSlash);
        }

        private static class Node {
            final Node next;
            final String value;

            Node(Node next, String value) {
                this.next = next;
                this.value = value;
            }
        }
    }

    public static class Query {
        private static final Query empty = Query.empty(__ -> {});
        private final Node head;
        private final UnaryOperator<String> validator;

        private Query(Node head, UnaryOperator<String> validator) {
            this.head = head;
            this.validator = Objects.requireNonNull(validator);
        }

        public static Query empty() {
            return empty;
        }

        public static Query empty(Consumer<String> validator) {
            return new Query(null, Query.entryValidator(validator));
        }

        public static Query parse(String raw) {
            if (raw == null) {
                return Query.empty();
            }
            return Query.parse(raw, __ -> {});
        }

        public static Query parse(String raw, Consumer<String> validator) {
            if (raw == null) {
                return Query.empty(validator);
            }
            Query query = Query.empty(validator);
            for (String pair : raw.split("&")) {
                int split = pair.indexOf("=");
                query = split == -1 ? query.add(URLDecoder.decode(pair, StandardCharsets.UTF_8)) : query.add(URLDecoder.decode(pair.substring(0, split), StandardCharsets.UTF_8), URLDecoder.decode(pair.substring(split + 1), StandardCharsets.UTF_8));
            }
            return query;
        }

        private static UnaryOperator<String> entryValidator(Consumer<String> validator) {
            Objects.requireNonNull(validator);
            return value -> {
                validator.accept((String)value);
                return value;
            };
        }

        public Query add(String key, String value) {
            return new Query(new Node(this.head, (String)this.validator.apply(Objects.requireNonNull(key)), (String)this.validator.apply(Objects.requireNonNull(value))), this.validator);
        }

        public Query add(String key) {
            return new Query(new Node(this.head, (String)this.validator.apply(Objects.requireNonNull(key)), null), this.validator);
        }

        public Query set(String key, String value) {
            return this.remove(key).add(key, value);
        }

        public Query set(String key) {
            return this.remove(key).add(key);
        }

        public Query remove(String key) {
            Node node = this.without(key::equals);
            return node == this.head ? this : new Query(node, this.validator);
        }

        private Node without(Predicate<String> filter) {
            Node head = null;
            boolean changed = false;
            for (Node node : this.nodes()) {
                if (filter.test(node.key)) {
                    changed = true;
                    continue;
                }
                head = changed ? new Node(head, node.key, node.value) : node;
            }
            return head;
        }

        public Query add(Map<String, ? extends Iterable<String>> values) {
            Query query = this;
            for (Map.Entry<String, ? extends Iterable<String>> entry : values.entrySet()) {
                for (String value : entry.getValue()) {
                    query = value == null ? query.add(entry.getKey()) : query.add(entry.getKey(), value);
                }
            }
            return query;
        }

        public Query set(Map<String, String> values) {
            Query query = this.remove(values.keySet());
            for (Map.Entry<String, String> entry : values.entrySet()) {
                query = entry.getValue() == null ? query.add(entry.getKey()) : query.add(entry.getKey(), entry.getValue());
            }
            return query;
        }

        public Query remove(Collection<String> keys) {
            Node node = this.without(keys::contains);
            return node == this.head ? this : new Query(node, this.validator);
        }

        public Map<String, String> lastEntries() {
            LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
            for (Node node : this.nodes()) {
                entries.put(node.key, node.value);
            }
            return entries;
        }

        public Map<String, List<String>> entries() {
            LinkedHashMap<String, List<String>> entries = new LinkedHashMap<String, List<String>>();
            for (Node node : this.nodes()) {
                entries.computeIfAbsent(node.key, __ -> new ArrayList(2)).add(node.value);
            }
            return entries;
        }

        private String raw() {
            StringJoiner joiner = new StringJoiner("&", "?", "").setEmptyValue("");
            for (Node node : this.nodes()) {
                joiner.add(URLEncoder.encode(node.key, StandardCharsets.UTF_8) + (String)(node.value == null ? "" : "=" + URLEncoder.encode(node.value, StandardCharsets.UTF_8)));
            }
            return joiner.toString();
        }

        private Iterable<Node> nodes() {
            ArrayDeque<Node> nodes = new ArrayDeque<Node>();
            Node node = this.head;
            while (node != null) {
                nodes.push(node);
                node = node.next;
            }
            return nodes;
        }

        public String toString() {
            return this.head == null ? "no query" : "query '" + this.raw().substring(1) + "'";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Query query = (Query)o;
            return this.entries().equals(query.entries());
        }

        public int hashCode() {
            return Objects.hash(this.entries());
        }

        private static class Node {
            final Node next;
            final String key;
            final String value;

            public Node(Node next, String key, String value) {
                this.next = next;
                this.key = key;
                this.value = value;
            }
        }
    }
}

