/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.slime;

final class BufferedInput {
    private final byte[] source;
    private final int end;
    private final int start;
    private int position;
    private String failReason;
    private int failPos;

    void fail(String reason) {
        if (this.failed()) {
            return;
        }
        this.failReason = reason;
        this.failPos = this.position;
        this.position = this.end;
    }

    BufferedInput(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    BufferedInput(byte[] bytes, int offset, int length) {
        this.source = bytes;
        this.start = offset;
        this.position = offset;
        this.end = offset + length;
    }

    byte getByte() {
        if (this.position == this.end) {
            this.fail("underflow");
            return 0;
        }
        return this.source[this.position++];
    }

    boolean failed() {
        return this.failReason != null;
    }

    boolean eof() {
        return this.position == this.end;
    }

    String getErrorMessage() {
        return this.failReason;
    }

    int getConsumedSize() {
        return this.failed() ? 0 : this.position - this.start;
    }

    byte[] getOffending() {
        byte[] ret = new byte[this.failPos - this.start];
        System.arraycopy(this.source, this.start, ret, 0, this.failPos - this.start);
        return ret;
    }

    byte[] getBacking() {
        return this.source;
    }

    int getPosition() {
        return this.position;
    }

    void skip(int size) {
        if (this.position + size > this.end) {
            this.fail("underflow");
        } else {
            this.position += size;
        }
    }

    byte[] getBytes(int size) {
        if (this.position + size > this.end) {
            this.fail("underflow");
            return new byte[0];
        }
        byte[] ret = new byte[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.source[this.position++];
        }
        return ret;
    }

    int read_cmpr_int() {
        long next = this.getByte();
        long value = next & 0x7FL;
        for (int shift = 7; shift < 32 && (next & 0x80L) != 0L; shift += 7) {
            next = this.getByte();
            value |= (next & 0x7FL) << shift;
        }
        if (value > Integer.MAX_VALUE) {
            this.fail("compressed int overflow");
            value = 0L;
        }
        return (int)value;
    }

    int skip_cmpr_int() {
        int extBits = 0;
        while ((this.getByte() & 0x80) != 0) {
            ++extBits;
        }
        return extBits;
    }

    int read_size(int meta) {
        return meta == 0 ? this.read_cmpr_int() : meta - 1;
    }
}

