/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.concurrent;

import com.yahoo.yolean.Exceptions;
import com.yahoo.yolean.UncheckedInterruptedException;
import java.time.Duration;

public interface Sleeper {
    public static final Sleeper DEFAULT = Thread::sleep;
    public static final Sleeper NOOP = millis -> {};

    default public void sleep(Duration duration) throws UncheckedInterruptedException {
        Exceptions.uncheckInterrupted(() -> this.sleepChecked(duration.toMillis()));
    }

    default public void sleepChecked(Duration duration) throws InterruptedException {
        this.sleepChecked(duration.toMillis());
    }

    default public void sleep(long millis) throws UncheckedInterruptedException {
        Exceptions.uncheckInterrupted(() -> this.sleepChecked(millis));
    }

    public void sleepChecked(long var1) throws InterruptedException;
}

