/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm;

import com.yahoo.api.annotations.Beta;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@Beta
public class InferenceParameters {
    public static final String OPTION_MODEL = "model";
    public static final String OPTION_TEMPERATURE = "temperature";
    public static final String OPTION_MAX_TOKENS = "maxTokens";
    public static final String OPTION_TOP_K = "topk";
    public static final String OPTION_TOP_P = "topp";
    public static final String OPTION_N_PREDICT = "npredict";
    public static final String OPTION_REPEAT_PENALTY = "repeatpenalty";
    public static final String OPTION_FREQUENCY_PENALTY = "frequencypenalty";
    public static final String OPTION_PRESENCE_PENALTY = "presencepenalty";
    public static final String OPTION_SEED = "seed";
    public static final String OPTION_JSON_SCHEMA = "json_schema";
    private String apiKey;
    private String endpoint;
    private final Function<String, String> options;

    public InferenceParameters(Function<String, String> options) {
        this(null, null, options);
    }

    public InferenceParameters(String apiKey, Function<String, String> options) {
        this(apiKey, null, options);
    }

    public InferenceParameters(String apiKey, String endpoint, Function<String, String> options) {
        this.apiKey = apiKey;
        this.endpoint = endpoint;
        this.options = Objects.requireNonNull(options);
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public Optional<String> getApiKey() {
        return Optional.ofNullable(this.apiKey);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Optional<String> getEndpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    public Optional<String> get(String option) {
        return Optional.ofNullable(this.options.apply(option));
    }

    public Optional<Double> getDouble(String option) {
        try {
            return Optional.of(Double.parseDouble(this.options.apply(option)));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<Integer> getInt(String option) {
        try {
            return Optional.of(Integer.parseInt(this.options.apply(option)));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<Long> getLong(String option) {
        try {
            return Optional.of(Long.parseLong(this.options.apply(option)));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public void ifPresent(String option, Consumer<String> func) {
        this.get(option).ifPresent(func);
    }

    public InferenceParameters withDefaultOptions(Function<String, String> defaultOptions) {
        Function<String, String> optionsWithDefault = key -> {
            String value = this.options.apply((String)key);
            return value != null ? value : (String)defaultOptions.apply((String)key);
        };
        return new InferenceParameters(this.apiKey, this.endpoint, optionsWithDefault);
    }
}

