/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yolean.concurrent;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;

public class ConcurrentResourcePool<T>
implements Iterable<T> {
    private final Queue<T> pool = new ConcurrentLinkedQueue<T>();
    private final Supplier<T> factory;

    public ConcurrentResourcePool(Supplier<T> factory) {
        this.factory = factory;
    }

    public void preallocate(int instances) {
        for (int i = 0; i < instances; ++i) {
            this.pool.offer(this.factory.get());
        }
    }

    public final T alloc() {
        T e = this.pool.poll();
        return e != null ? e : this.factory.get();
    }

    public final void free(T e) {
        this.pool.offer(e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.pool.iterator();
    }
}

