/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public abstract class LazyMap<K, V>
implements Map<K, V> {
    private Map<K, V> delegate = this.newEmpty();

    @Override
    public final int size() {
        return this.delegate.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public final V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public final V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public final V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }

    @Override
    public final void clear() {
        this.delegate.clear();
    }

    @Override
    public final Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public final Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public final int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return obj == this || obj instanceof Map && this.delegate.equals(obj);
    }

    private Map<K, V> newEmpty() {
        return new EmptyMap();
    }

    private Map<K, V> newSingleton(K key, V value) {
        return new SingletonMap(key, value);
    }

    protected abstract Map<K, V> newDelegate();

    final Map<K, V> getDelegate() {
        return this.delegate;
    }

    public static <K, V> LazyMap<K, V> newHashMap() {
        return new LazyMap<K, V>(){

            @Override
            protected Map<K, V> newDelegate() {
                return new HashMap();
            }
        };
    }

    class EmptyMap
    extends AbstractMap<K, V> {
        EmptyMap() {
        }

        @Override
        public V put(K key, V value) {
            LazyMap.this.delegate = LazyMap.this.newSingleton(key, value);
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            switch (m.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Map.Entry entry = m.entrySet().iterator().next();
                    this.put(entry.getKey(), entry.getValue());
                    break;
                }
                default: {
                    LazyMap.this.delegate = LazyMap.this.newDelegate();
                    LazyMap.this.delegate.putAll(m);
                }
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }
    }

    class SingletonMap
    extends AbstractMap<K, V> {
        final K key;
        V value;

        SingletonMap(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public V put(K key, V value) {
            if (this.containsKey(key)) {
                Object oldValue = this.value;
                this.value = value;
                return oldValue;
            }
            LazyMap.this.delegate = LazyMap.this.newDelegate();
            LazyMap.this.delegate.put(this.key, this.value);
            return LazyMap.this.delegate.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            switch (m.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Map.Entry entry = m.entrySet().iterator().next();
                    this.put(entry.getKey(), entry.getValue());
                    break;
                }
                default: {
                    LazyMap.this.delegate = LazyMap.this.newDelegate();
                    LazyMap.this.delegate.put(this.key, this.value);
                    LazyMap.this.delegate.putAll(m);
                }
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        boolean hasNext = true;

                        @Override
                        public boolean hasNext() {
                            return this.hasNext;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (this.hasNext) {
                                this.hasNext = false;
                                return new Map.Entry<K, V>(){

                                    @Override
                                    public K getKey() {
                                        return SingletonMap.this.key;
                                    }

                                    @Override
                                    public V getValue() {
                                        return SingletonMap.this.value;
                                    }

                                    @Override
                                    public V setValue(V value) {
                                        Object oldValue = SingletonMap.this.value;
                                        SingletonMap.this.value = value;
                                        return oldValue;
                                    }

                                    @Override
                                    public int hashCode() {
                                        return Objects.hashCode(SingletonMap.this.key) + Objects.hashCode(SingletonMap.this.value) * 31;
                                    }

                                    @Override
                                    public boolean equals(Object obj) {
                                        if (obj == this) {
                                            return true;
                                        }
                                        if (!(obj instanceof Map.Entry)) {
                                            return false;
                                        }
                                        Map.Entry rhs = (Map.Entry)obj;
                                        if (!Objects.equals(SingletonMap.this.key, rhs.getKey())) {
                                            return false;
                                        }
                                        return Objects.equals(SingletonMap.this.value, rhs.getValue());
                                    }
                                };
                            }
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            if (this.hasNext) {
                                throw new IllegalStateException();
                            }
                            LazyMap.this.delegate = LazyMap.this.newEmpty();
                        }
                    };
                }

                @Override
                public int size() {
                    return 1;
                }
            };
        }
    }
}

