/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text;

import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;

public class DataTypeIdentifier {
    private static final byte[] ARRAY = new byte[]{97, 114, 114, 97, 121};
    private static final byte[] ANNOTATIONREFERENCE = new byte[]{97, 110, 110, 111, 116, 97, 116, 105, 111, 110, 114, 101, 102, 101, 114, 101, 110, 99, 101};
    private static final byte[] MAP = new byte[]{109, 97, 112};
    private static final byte[] WSET = new byte[]{119, 101, 105, 103, 104, 116, 101, 100, 115, 101, 116};
    private static final byte[] CREATEIFNONEXISTENT = new byte[]{59, 97, 100, 100};
    private static final byte[] REMOVEIFZERO = new byte[]{59, 114, 101, 109, 111, 118, 101};
    private static final byte[] CREATANDREMOVE = new byte[]{59, 97, 100, 100, 59, 114, 101, 109, 111, 118, 101};
    private static final byte[] EMPTY = new byte[0];
    private Utf8String utf8;

    public DataTypeIdentifier(String s) {
        this.utf8 = new Utf8String(s);
        DataTypeIdentifier.verify(this.utf8.wrap().array());
    }

    public DataTypeIdentifier(AbstractUtf8Array utf8) {
        this.utf8 = new Utf8String(utf8);
        DataTypeIdentifier.verify(utf8.wrap().array());
    }

    public DataTypeIdentifier(byte[] utf8) {
        this(new Utf8Array(utf8));
    }

    private DataTypeIdentifier(byte[] prefix, DataTypeIdentifier nested, byte[] postfix) {
        this.utf8 = new Utf8String(new Utf8Array(DataTypeIdentifier.createPrefixDataType(prefix, nested, postfix)));
    }

    private DataTypeIdentifier(byte[] prefix, DataTypeIdentifier key, DataTypeIdentifier value) {
        this.utf8 = new Utf8String(new Utf8Array(DataTypeIdentifier.createMapDataType(prefix, key, value)));
    }

    public static DataTypeIdentifier createArrayDataTypeIdentifier(DataTypeIdentifier nested) {
        return new DataTypeIdentifier(ARRAY, nested, EMPTY);
    }

    public static DataTypeIdentifier createAnnotationReferenceDataTypeIdentifier(DataTypeIdentifier nested) {
        return new DataTypeIdentifier(ANNOTATIONREFERENCE, nested, EMPTY);
    }

    public static DataTypeIdentifier createMapDataTypeIdentifier(DataTypeIdentifier key, DataTypeIdentifier value) {
        return new DataTypeIdentifier(MAP, key, value);
    }

    public static DataTypeIdentifier createWeightedSetTypeIdentifier(DataTypeIdentifier nested, boolean createIfNonExistent, boolean removeIfZero) {
        return new DataTypeIdentifier(WSET, nested, DataTypeIdentifier.createPostfix(createIfNonExistent, removeIfZero));
    }

    public int hashCode() {
        return this.utf8.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataTypeIdentifier) {
            return this.utf8.equals(((DataTypeIdentifier)obj).utf8);
        }
        return false;
    }

    public String toString() {
        return this.utf8.toString();
    }

    public final Utf8String getUtf8() {
        return this.utf8;
    }

    private static byte[] createPostfix(boolean createIfNonExistent, boolean removeIfZero) {
        if (createIfNonExistent && removeIfZero) {
            return CREATANDREMOVE;
        }
        if (createIfNonExistent) {
            return CREATEIFNONEXISTENT;
        }
        if (removeIfZero) {
            return REMOVEIFZERO;
        }
        return EMPTY;
    }

    private static byte[] createPrefixDataType(byte[] prefix, DataTypeIdentifier nested, byte[] postfix) {
        int i;
        byte[] whole = new byte[prefix.length + 2 + nested.utf8.getByteLength() + postfix.length];
        for (i = 0; i < prefix.length; ++i) {
            whole[i] = prefix[i];
        }
        whole[prefix.length] = 60;
        int m = nested.utf8.getByteLength();
        for (i = 0; i < m; ++i) {
            whole[prefix.length + 1 + i] = nested.utf8.getByte(i);
        }
        whole[prefix.length + 1 + nested.utf8.getByteLength()] = 62;
        for (i = 0; i < postfix.length; ++i) {
            whole[prefix.length + 1 + nested.utf8.length() + 1 + i] = postfix[i];
        }
        return whole;
    }

    private static byte[] createMapDataType(byte[] prefix, DataTypeIdentifier key, DataTypeIdentifier value) {
        int i;
        byte[] whole = new byte[prefix.length + 3 + key.utf8.getByteLength() + value.utf8.getByteLength()];
        for (i = 0; i < prefix.length; ++i) {
            whole[i] = prefix[i];
        }
        whole[prefix.length] = 60;
        int m = key.utf8.getByteLength();
        for (i = 0; i < m; ++i) {
            whole[prefix.length + 1 + i] = key.utf8.getByte(i);
        }
        whole[prefix.length + 1 + key.utf8.getByteLength()] = 44;
        for (i = 0; i < value.utf8.getByteLength(); ++i) {
            whole[prefix.length + 1 + key.utf8.getByteLength() + 1 + i] = value.utf8.getByte(i);
        }
        whole[whole.length - 1] = 62;
        return whole;
    }

    private static byte[] verify(byte[] utf8) {
        if (utf8.length > 0) {
            DataTypeIdentifier.verifyFirst(utf8[0], utf8);
            for (int i = 1; i < utf8.length; ++i) {
                DataTypeIdentifier.verifyAny(utf8[i], utf8);
            }
        }
        return utf8;
    }

    private static boolean verifyFirst(byte c, byte[] identifier) {
        if (c != 95 && (c < 97 || c > 122)) {
            throw new IllegalArgumentException("Illegal starting character '" + (char)c + "' of identifier '" + new Utf8String(new Utf8Array(identifier)).toString() + "'.");
        }
        return true;
    }

    private static boolean verifyAny(byte c, byte[] identifier) {
        if (!(c == 95 || c == 46 || c >= 97 && c <= 122 || c >= 48 && c <= 57)) {
            throw new IllegalArgumentException("Illegal character '" + (char)c + "' of identifier '" + new Utf8String(new Utf8Array(identifier)).toString() + "'.");
        }
        return true;
    }
}

