/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.geo;

class OneDegreeParser {
    public double latitude = 0.0;
    public boolean foundLatitude = false;
    public double longitude = 0.0;
    public boolean foundLongitude = false;
    private String parseString = null;
    private int len = 0;
    private int pos = 0;

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isCompassDirection(char ch) {
        return ch == 'N' || ch == 'S' || ch == 'E' || ch == 'W';
    }

    public String toString() {
        if (this.foundLatitude) {
            return this.parseString + " -> latitude(" + this.latitude + ")";
        }
        return this.parseString + " -> longitude(" + this.longitude + ")";
    }

    private char getNextChar() throws IllegalArgumentException {
        if (this.pos == this.len) {
            ++this.pos;
            return '\u0000';
        }
        if (this.pos > this.len) {
            throw new IllegalArgumentException("position after end of string when parsing <" + this.parseString + ">");
        }
        return this.parseString.charAt(this.pos++);
    }

    public OneDegreeParser(boolean assumeNorthSouth, String toParse) throws IllegalArgumentException {
        this.parseString = toParse;
        this.len = this.parseString.length();
        this.consumeString(assumeNorthSouth);
    }

    private void consumeString(boolean assumeNorthSouth) throws IllegalArgumentException {
        char ch = this.getNextChar();
        double degrees = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        boolean degSet = false;
        boolean minSet = false;
        boolean secSet = false;
        boolean dirSet = false;
        boolean foundDot = false;
        boolean foundDigits = false;
        boolean findingLatitude = false;
        boolean findingLongitude = false;
        double sign = 1.0;
        int lastpos = -1;
        if (ch == '+') {
            ch = this.getNextChar();
        } else if (ch == '-') {
            sign = -1.0;
            ch = this.getNextChar();
        }
        do {
            boolean valid = false;
            if (this.pos == lastpos) {
                throw new IllegalArgumentException("internal logic error at <" + this.parseString + "> pos:" + this.pos);
            }
            lastpos = this.pos;
            double accum = 0.0;
            if (OneDegreeParser.isDigit(ch) || ch == '.') {
                valid = true;
                double divider = 1.0;
                foundDot = false;
                while (OneDegreeParser.isDigit(ch)) {
                    foundDigits = true;
                    accum *= 10.0;
                    accum += (double)(ch - 48);
                    ch = this.getNextChar();
                }
                if (ch == '.') {
                    foundDot = true;
                    ch = this.getNextChar();
                    while (OneDegreeParser.isDigit(ch)) {
                        foundDigits = true;
                        accum *= 10.0;
                        accum += (double)(ch - 48);
                        divider *= 10.0;
                        ch = this.getNextChar();
                    }
                }
                if (!foundDigits) {
                    throw new IllegalArgumentException("just a . is not a valid number when parsing <" + this.parseString + ">");
                }
                accum /= divider;
            }
            if (ch == '\u00b0' || ch == 'o') {
                valid = true;
                if (degSet) {
                    throw new IllegalArgumentException("degrees sign only valid just after degrees when parsing <" + this.parseString + ">");
                }
                if (!foundDigits) {
                    throw new IllegalArgumentException("must have number before degrees sign when parsing <" + this.parseString + ">");
                }
                if (foundDot) {
                    throw new IllegalArgumentException("cannot have fractional degrees before degrees sign when parsing <" + this.parseString + ">");
                }
                ch = this.getNextChar();
            }
            if (ch == '\'') {
                if (minSet || !degSet || !foundDigits) {
                    throw new IllegalArgumentException("minutes sign only valid just after minutes when parsing <" + this.parseString + ">");
                }
                if (foundDot) {
                    throw new IllegalArgumentException("cannot have fractional minutes before minutes sign when parsing <" + this.parseString + ">");
                }
                ch = this.getNextChar();
            }
            if (foundDigits) {
                valid = true;
                if (degSet) {
                    if (minSet) {
                        if (secSet) {
                            throw new IllegalArgumentException("extra number after full field when parsing <" + this.parseString + ">");
                        }
                        seconds = accum;
                        secSet = true;
                    } else {
                        minutes = accum;
                        minSet = true;
                        if (foundDot) {
                            secSet = true;
                        }
                    }
                } else {
                    degrees = accum;
                    degSet = true;
                    if (foundDot) {
                        minSet = true;
                        secSet = true;
                    }
                }
                foundDot = false;
                foundDigits = false;
            }
            if (OneDegreeParser.isCompassDirection(ch)) {
                valid = true;
                if (dirSet) {
                    throw new IllegalArgumentException("already set direction once, cannot add direction: " + ch + " when parsing <" + this.parseString + ">");
                }
                dirSet = true;
                sign = ch == 'S' || ch == 'W' ? -1.0 : 1.0;
                if (ch == 'E' || ch == 'W') {
                    findingLongitude = true;
                } else {
                    findingLatitude = true;
                }
                ch = this.getNextChar();
            }
            if (ch == '\u0000') {
                valid = true;
                if (!dirSet) {
                    if (assumeNorthSouth) {
                        findingLatitude = true;
                    } else {
                        findingLongitude = true;
                    }
                }
                if (!degSet) {
                    throw new IllegalArgumentException("end of field without any number seen when parsing <" + this.parseString + ">");
                }
                degrees += minutes / 60.0;
                degrees += seconds / 3600.0;
                degrees *= sign;
                if (findingLatitude) {
                    if (degrees < -90.0 || degrees > 90.0) {
                        throw new IllegalArgumentException("out of range [-90,+90]: " + degrees + " when parsing <" + this.parseString + ">");
                    }
                    this.latitude = degrees;
                    this.foundLatitude = true;
                    break;
                }
                if (!findingLongitude) break;
                if (degrees < -180.0 || degrees > 180.0) {
                    throw new IllegalArgumentException("out of range [-180,+180]: " + degrees + " when parsing <" + this.parseString + ">");
                }
                this.longitude = degrees;
                this.foundLongitude = true;
                break;
            }
            if (valid) continue;
            throw new IllegalArgumentException("invalid character: " + ch + " when parsing <" + this.parseString + ">");
        } while (ch != '\u0000');
        if (this.foundLatitude && this.foundLongitude) {
            throw new IllegalArgumentException("found both latitude and longitude from: " + this.parseString);
        }
        if (this.foundLatitude || this.foundLongitude) {
            return;
        }
        throw new IllegalArgumentException("found neither latitude nor longitude from: " + this.parseString);
    }
}

