/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedhandler;

import com.yahoo.document.DocumentTypeManager;
import com.yahoo.feedapi.FeedContext;
import com.yahoo.feedapi.MessagePropertyProcessor;
import com.yahoo.feedapi.SharedSender;
import com.yahoo.feedhandler.InputStreamRequest;
import com.yahoo.feedhandler.ParameterParser;
import java.io.InputStream;

public abstract class VespaFeedHandlerBase {
    protected FeedContext context;
    private final long defaultTimeoutMillis;

    VespaFeedHandlerBase(FeedContext context) {
        this(context, context.getPropertyProcessor().getDefaultTimeoutMillis());
    }

    private VespaFeedHandlerBase(FeedContext context, long defaultTimeoutMillis) {
        this.context = context;
        this.defaultTimeoutMillis = defaultTimeoutMillis;
    }

    SharedSender getSharedSender(String route) {
        return this.context.getSharedSender(route);
    }

    MessagePropertyProcessor getPropertyProcessor() {
        return this.context.getPropertyProcessor();
    }

    InputStream getRequestInputStream(InputStreamRequest request) {
        return request.getData();
    }

    protected DocumentTypeManager getDocumentTypeManager() {
        return this.context.getDocumentTypeManager();
    }

    protected long getTimeoutMillis(InputStreamRequest request) {
        return ParameterParser.asMilliSeconds(request.getProperty("timeout"), this.defaultTimeoutMillis);
    }
}

