/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.clientmetrics;

import com.yahoo.concurrent.Timer;
import com.yahoo.documentapi.messagebus.protocol.DocumentIgnoredReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Reply;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class MessageTypeMetricSet {
    public long latency_total;
    public long latency_min = Long.MAX_VALUE;
    public long latency_max = Long.MIN_VALUE;
    public long count = 0L;
    public long ignored = 0L;
    public long errorCount = 0L;
    public final Timer timer;
    private final Map<String, Long> errorCounts = new HashMap<String, Long>();
    private final String msgName;

    MessageTypeMetricSet(String msgName, Timer timer) {
        this.msgName = msgName;
        this.timer = timer;
    }

    public String getMessageName() {
        return this.msgName;
    }

    public void addReply(Reply r) {
        if (!r.hasErrors() || MessageTypeMetricSet.onlyTestAndSetConditionFailed(r.getErrors())) {
            this.updateSuccessMetrics(r);
        } else {
            this.updateFailureMetrics(r);
        }
    }

    private void updateFailureMetrics(Reply r) {
        ++this.errorCount;
        String error = DocumentProtocol.getErrorName((int)r.getError(0).getCode());
        Long s = this.errorCounts.get(error);
        if (s == null) {
            this.errorCounts.put(error, 1L);
        } else {
            this.errorCounts.put(error, s + 1L);
        }
    }

    private void updateSuccessMetrics(Reply r) {
        if (!(r instanceof DocumentIgnoredReply)) {
            if (r.getMessage().getTimeReceived() != 0L) {
                long latency = this.timer.milliTime() - r.getMessage().getTimeReceived();
                this.latency_max = Math.max(this.latency_max, latency);
                this.latency_min = Math.min(this.latency_min, latency);
                this.latency_total += latency;
            }
            ++this.count;
        } else {
            ++this.ignored;
        }
    }

    private static boolean onlyTestAndSetConditionFailed(Stream<Error> errors) {
        return errors.allMatch(e -> e.getCode() == 251013);
    }
}

