/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.feedapi;

import com.yahoo.clientmetrics.RouteMetricSet;
import com.yahoo.concurrent.SystemTimer;
import com.yahoo.feedapi.SendSession;
import com.yahoo.feedapi.SessionFactory;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import com.yahoo.messagebus.Routable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedSender
implements ReplyHandler {
    public static final Logger log = Logger.getLogger(SharedSender.class.getName());
    private final SendSession sender;
    private final RouteMetricSet metrics;
    private final Pending globalPending = new Pending();

    SharedSender(String route, SessionFactory factory, SharedSender oldSender) {
        this.sender = factory != null ? factory.createSendSession(this) : null;
        this.metrics = oldSender != null ? oldSender.metrics : new RouteMetricSet(route, null);
    }

    public RouteMetricSet getMetrics() {
        return this.metrics;
    }

    public void shutdown() {
        try {
            this.globalPending.waitForZero();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sender.close();
    }

    boolean waitForPending(ResultCallback owner, long timeoutMs) {
        try {
            return owner.getPending().waitForZero(timeoutMs);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public void send(Message msg, ResultCallback owner) {
        this.send(msg, owner, true);
    }

    public void send(Message msg, ResultCallback owner, boolean blockingQueue) {
        Result r;
        if (owner.isAborted()) {
            return;
        }
        msg.setContext((Object)owner);
        owner.getPending().inc();
        this.globalPending.inc();
        try {
            r = this.sender.send(msg, blockingQueue);
        }
        catch (InterruptedException e) {
            r = null;
        }
        if (r == null || !r.isAccepted()) {
            EmptyReply reply = new EmptyReply();
            msg.swapState((Routable)reply);
            reply.setMessage(msg);
            if (r != null) {
                reply.addError(r.getError());
            }
            this.handleReply((Reply)reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReply(Reply r) {
        this.globalPending.dec();
        ResultCallback owner = (ResultCallback)r.getContext();
        if (owner != null) {
            RouteMetricSet routeMetricSet = this.metrics;
            synchronized (routeMetricSet) {
                this.metrics.addReply(r);
            }
            log.log(Level.FINEST, () -> "Received reply for file " + owner.toString() + " count was " + owner.getPending().val());
            if (owner.isAborted()) {
                log.log(Level.FINE, () -> "Received reply for file " + owner.toString() + " which is aborted");
                owner.getPending().clear();
                return;
            }
            if (owner.handleReply(r)) {
                owner.getPending().dec();
            } else {
                log.log(Level.FINE, () -> "Received reply for file " + owner.toString() + " which wants to abort");
                owner.getPending().clear();
            }
        } else {
            log.log(Level.WARNING, "Received reply " + r + " for message " + r.getMessage() + " without context");
        }
    }

    public static class Pending {
        private int value = 0;

        public synchronized void inc() {
            ++this.value;
        }

        synchronized void dec() {
            if (--this.value == 0) {
                this.notifyAll();
            }
        }

        public synchronized void clear() {
            this.value = 0;
            this.notifyAll();
        }

        public synchronized int val() {
            return this.value;
        }

        synchronized boolean waitForZero() throws InterruptedException {
            while (this.value > 0) {
                this.wait();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitForZero(long timeoutMs) throws InterruptedException {
            if (timeoutMs == -1L) {
                return this.waitForZero();
            }
            long timeStart = SystemTimer.INSTANCE.milliTime();
            long timeLeft = timeoutMs;
            while (timeLeft > 0L) {
                Pending pending = this;
                synchronized (pending) {
                    if (this.value <= 0) {
                        return true;
                    }
                    this.wait(timeLeft);
                }
                long elapsed = SystemTimer.INSTANCE.milliTime() - timeStart;
                timeLeft = timeoutMs - elapsed;
            }
            return false;
        }
    }

    public static interface ResultCallback {
        public Pending getPending();

        public boolean handleReply(Reply var1);

        public boolean isAborted();
    }
}

