/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi.resource;

import com.yahoo.document.restapi.resource.ResponseWriter;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.BufferedContentChannel;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class BufferedContentChannelResponseWriter
implements ResponseWriter {
    private static final Logger log = Logger.getLogger(BufferedContentChannelResponseWriter.class.getName());
    private static final CompletionHandler FAILURE_LOGGING_COMPLETION_HANDLER = new CompletionHandler(){

        public void completed() {
        }

        public void failed(Throwable t) {
            log.log(Level.FINE, "Exception writing or closing response data", t);
        }
    };
    private final BufferedContentChannel buffer = new BufferedContentChannel();
    private final ResponseHandler handler;
    private final Object lock = new Object();
    private ContentChannel channel;

    public BufferedContentChannelResponseWriter(ResponseHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(int status, String contentType, boolean fullyApplied) throws IOException {
        Response response = new Response(status);
        if (contentType != null) {
            response.headers().add("Content-Type", List.of(contentType));
        }
        if (!fullyApplied) {
            response.headers().add("X-Vespa-Ignored-Fields", "true");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.channel != null) {
                throw new IllegalStateException("commit called multiple times on same response writer");
            }
            try {
                this.channel = this.handler.handleResponse(response);
                this.buffer.connectTo(this.channel);
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void write(ByteBuffer buf, CompletionHandler completionHandlerOrNull) {
        CompletionHandler handler = completionHandlerOrNull;
        if (handler == null) {
            handler = FAILURE_LOGGING_COMPLETION_HANDLER;
        }
        this.buffer.write(buf, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.channel == null) {
                    log.log(Level.WARNING, "Close called before response was committed, in " + this.getClass().getName());
                    this.commit(500, null, true);
                }
            }
            finally {
                if (this.channel != null) {
                    this.channel.close(FAILURE_LOGGING_COMPLETION_HANDLER);
                }
            }
        }
    }
}

