/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.plugin;

import ai.vespa.hosted.cd.ProductionTest;
import ai.vespa.hosted.cd.StagingSetup;
import ai.vespa.hosted.cd.StagingTest;
import ai.vespa.hosted.cd.SystemTest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

class TestAnnotationAnalyzer {
    private final List<String> systemTests = new ArrayList<String>();
    private final List<String> stagingTests = new ArrayList<String>();
    private final List<String> stagingSetupTests = new ArrayList<String>();
    private final List<String> productionTests = new ArrayList<String>();

    TestAnnotationAnalyzer() {
    }

    List<String> systemTests() {
        return this.systemTests;
    }

    List<String> stagingTests() {
        return this.stagingTests;
    }

    List<String> stagingSetupTests() {
        return this.stagingSetupTests;
    }

    List<String> productionTests() {
        return this.productionTests;
    }

    void analyzeClass(Path classFile) {
        try (InputStream in = Files.newInputStream(classFile, new OpenOption[0]);){
            new ClassReader(in).accept((ClassVisitor)new AsmClassVisitor(), 2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class AsmClassVisitor
    extends ClassVisitor {
        private String className;

        AsmClassVisitor() {
            super(458752);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            Type type = Type.getObjectType((String)name);
            if (type.getSort() == 10) {
                this.className = type.getClassName();
                super.visit(version, access, name, signature, superName, interfaces);
            }
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            String annotationClassName = Type.getType((String)descriptor).getClassName();
            if (ProductionTest.class.getName().equals(annotationClassName)) {
                TestAnnotationAnalyzer.this.productionTests.add(this.className);
            } else if (StagingTest.class.getName().equals(annotationClassName)) {
                TestAnnotationAnalyzer.this.stagingTests.add(this.className);
            } else if (StagingSetup.class.getName().equals(annotationClassName)) {
                TestAnnotationAnalyzer.this.stagingSetupTests.add(this.className);
            } else if (SystemTest.class.getName().equals(annotationClassName)) {
                TestAnnotationAnalyzer.this.systemTests.add(this.className);
            }
            return null;
        }
    }
}

