/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.FeedClient;
import ai.vespa.feed.client.HttpResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GracePeriodCircuitBreaker
implements FeedClient.CircuitBreaker {
    private static final Logger log = Logger.getLogger(GracePeriodCircuitBreaker.class.getName());
    private final AtomicBoolean halfOpen = new AtomicBoolean(false);
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final LongSupplier nanoClock;
    private final long never;
    private final AtomicLong failingSinceNanos;
    private final AtomicReference<String> detail = new AtomicReference();
    private final long graceNanos;
    private final long doomNanos;

    public GracePeriodCircuitBreaker(Duration grace) {
        this(System::nanoTime, grace, null);
    }

    public GracePeriodCircuitBreaker(Duration grace, Duration doom) {
        this(System::nanoTime, grace, doom);
        if (doom.isNegative()) {
            throw new IllegalArgumentException("Doom delay must be non-negative");
        }
    }

    GracePeriodCircuitBreaker(LongSupplier nanoClock, Duration grace, Duration doom) {
        if (grace.isNegative()) {
            throw new IllegalArgumentException("Grace delay must be non-negative");
        }
        this.nanoClock = Objects.requireNonNull(nanoClock);
        this.never = nanoClock.getAsLong() + 0x1000000000000000L;
        this.graceNanos = grace.toNanos();
        this.doomNanos = doom == null ? -1L : doom.toNanos();
        this.failingSinceNanos = new AtomicLong(this.never);
    }

    public void success() {
        this.failingSinceNanos.set(this.never);
        if (!this.open.get() && this.halfOpen.compareAndSet(true, false)) {
            log.log(Level.INFO, "Circuit breaker is now closed, after a request was successful");
        }
    }

    public void failure(HttpResponse response) {
        this.failure(response.toString());
    }

    public void failure(Throwable cause) {
        this.failure(cause.toString());
    }

    private void failure(String detail) {
        if (this.failingSinceNanos.compareAndSet(this.never, this.nanoClock.getAsLong())) {
            this.detail.set(detail);
        }
    }

    public FeedClient.CircuitBreaker.State state() {
        long failingNanos = this.nanoClock.getAsLong() - this.failingSinceNanos.get();
        if (failingNanos > this.graceNanos && this.halfOpen.compareAndSet(false, true)) {
            log.log(Level.INFO, "Circuit breaker is now half-open, as no requests have succeeded for the last " + failingNanos / 1000000L + "ms. The server will be pinged to see if it recovers" + (String)(this.doomNanos >= 0L ? ", but this client will give up if no successes are observed within " + this.doomNanos / 1000000L + "ms" : "") + ". First failure was '" + this.detail.get() + "'.");
        }
        if (this.doomNanos >= 0L && failingNanos > this.doomNanos && this.open.compareAndSet(false, true)) {
            log.log(Level.WARNING, "Circuit breaker is now open, after " + this.doomNanos / 1000000L + "ms of failing request, and this client will give up and abort its remaining feed operations.");
        }
        return this.open.get() ? FeedClient.CircuitBreaker.State.OPEN : (this.halfOpen.get() ? FeedClient.CircuitBreaker.State.HALF_OPEN : FeedClient.CircuitBreaker.State.CLOSED);
    }
}

