/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

class HttpRequest {
    private final String method;
    private final String path;
    private final String query;
    private final Map<String, Supplier<String>> headers;
    private final byte[] body;
    private final Duration timeout;
    private final long deadlineNanos;
    private final LongSupplier nanoClock;
    private final AtomicLong firstDispatchNanos = new AtomicLong(-1L);

    public HttpRequest(String method, String path, String query, Map<String, Supplier<String>> headers, byte[] body, Duration timeout, LongSupplier nanoClock) {
        this.method = method;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.body = body;
        this.deadlineNanos = nanoClock.getAsLong() + timeout.toNanos();
        this.timeout = timeout;
        this.nanoClock = nanoClock;
    }

    public String method() {
        return this.method;
    }

    public String pathAndQuery() {
        return this.path + (String)(this.query.isEmpty() ? "?" : this.query + "&") + "timeout=" + Math.max(1L, this.timeLeft().toMillis()) + "ms";
    }

    public Map<String, Supplier<String>> headers() {
        return this.headers;
    }

    public byte[] body() {
        return this.body;
    }

    public Duration timeLeft() {
        return Duration.ofNanos(this.deadlineNanos - this.nanoClock.getAsLong());
    }

    public Duration timeout() {
        return this.timeout;
    }

    void onDispatch(long timeNs) {
        this.firstDispatchNanos.compareAndSet(-1L, timeNs);
    }

    Optional<Long> firstDispatchNanos() {
        return Optional.of(this.firstDispatchNanos.get()).filter(ns -> ns >= 0L);
    }

    public String toString() {
        return this.method + " " + this.path;
    }
}

