/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client.impl;

import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.impl.Cluster;
import ai.vespa.feed.client.impl.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

class DryrunCluster
implements Cluster {
    private static final Logger log = Logger.getLogger(DryrunCluster.class.getName());
    static final Duration DELAY = Duration.ofMillis(1L);

    DryrunCluster() {
    }

    @Override
    public void dispatch(HttpRequest request, CompletableFuture<HttpResponse> vessel) {
        long millis = DELAY.toMillis();
        log.log(Level.FINE, "Dryrun of request '{0}' with delay of {1}ms", new Object[]{request, millis});
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                vessel.cancel(true);
                Thread.currentThread().interrupt();
                return;
            }
        }
        vessel.complete(new SimpleOkResponse());
    }

    private static class SimpleOkResponse
    implements HttpResponse {
        private SimpleOkResponse() {
        }

        public int code() {
            return 200;
        }

        public byte[] body() {
            return "{\"message\":\"dummy dryrun message\"}".getBytes(StandardCharsets.UTF_8);
        }
    }
}

