/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import java.util.List;

public enum NodeType {
    STORAGE("storage"),
    DISTRIBUTOR("distributor");

    private final String serializeAs;

    private NodeType(String serializeAs) {
        this.serializeAs = serializeAs;
    }

    public String toString() {
        return this.serializeAs;
    }

    public static NodeType get(String serialized) {
        for (NodeType type : NodeType.values()) {
            if (!type.serializeAs.equals(serialized)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown node type '" + serialized + "'. Legal values are 'storage' and 'distributor'.");
    }

    public static List<NodeType> getTypes() {
        return List.of(STORAGE, DISTRIBUTOR);
    }
}

