/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import com.yahoo.vdslib.state.NodeType;
import java.util.ArrayList;

public enum State {
    UNKNOWN("-", true, true, false, false, false, false, false),
    MAINTENANCE("m", false, false, true, true, false, true, true),
    DOWN("d", true, true, true, true, true, true, true),
    STOPPING("s", true, true, false, false, true, true, true),
    INITIALIZING("i", true, true, false, false, true, true, true),
    RETIRED("r", false, false, false, true, false, true, true),
    UP("u", true, true, true, true, true, true, true);

    private final boolean validClusterState;
    private final ArrayList<Boolean> validReportedNodeState = new ArrayList();
    private final ArrayList<Boolean> validWantedNodeState = new ArrayList();
    private final ArrayList<Boolean> validCurrentNodeState = new ArrayList();
    private final String serializedAs;

    private State(String serialized, boolean validDistReported, boolean validStorReported, boolean validDistWanted, boolean validStorWanted, boolean validCluster, boolean validDistCurrent, boolean validStorCurrent) {
        this.validClusterState = validCluster;
        this.validReportedNodeState.add(validStorReported);
        this.validReportedNodeState.add(validDistReported);
        this.validWantedNodeState.add(validStorWanted);
        this.validWantedNodeState.add(validDistWanted);
        this.validCurrentNodeState.add(validStorCurrent);
        this.validCurrentNodeState.add(validDistCurrent);
        this.serializedAs = serialized;
    }

    public static State get(String serialized) {
        for (State s : State.values()) {
            if (!s.serializedAs.equals(serialized)) continue;
            return s;
        }
        throw new IllegalArgumentException("Invalid state '" + serialized + "'.");
    }

    public String serialize() {
        return this.serializedAs;
    }

    public boolean validClusterState() {
        return this.validClusterState;
    }

    public boolean validReportedNodeState(NodeType type) {
        return this.validReportedNodeState.get(type.ordinal());
    }

    public boolean validWantedNodeState(NodeType type) {
        return this.validWantedNodeState.get(type.ordinal());
    }

    public boolean validCurrentNodeState(NodeType type) {
        return this.validCurrentNodeState.get(type.ordinal());
    }

    public boolean maySetWantedStateForThisNodeState(State s) {
        return s.ordinal() <= this.ordinal();
    }

    public boolean oneOf(String states) {
        for (char c : states.toCharArray()) {
            String s = "" + c;
            if (!s.equals(this.serializedAs)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String id = this.name();
        String lower = id.substring(1).toLowerCase();
        return id.charAt(0) + lower;
    }
}

