/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.distribution;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.BucketId;
import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Group;
import com.yahoo.vdslib.distribution.GroupVisitor;
import com.yahoo.vdslib.distribution.RandomGen;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.config.content.DistributionConfig;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class Distribution {
    private ConfigSubscriber configSub;
    private final AtomicReference<Config> config = new AtomicReference<Config>(new Config(null, 1));
    private ConfigSubscriber.SingleSubscriber<StorDistributionConfig> configSubscriber = config -> {
        try {
            Group root = null;
            for (int i = 0; i < config.group().size(); ++i) {
                Group group;
                int index;
                StorDistributionConfig.Group cg = config.group(i);
                int[] path = new int[]{};
                if (root != null) {
                    path = Distribution.getGroupPath(cg.index());
                }
                boolean isLeafGroup = cg.nodes().size() > 0;
                int n = index = path.length == 0 ? 0 : path[path.length - 1];
                if (isLeafGroup) {
                    group = new Group(index, cg.name());
                    ArrayList<ConfiguredNode> nodes = new ArrayList<ConfiguredNode>();
                    for (StorDistributionConfig.Group.Nodes node : cg.nodes()) {
                        nodes.add(new ConfiguredNode(node.index(), node.retired()));
                    }
                    group.setNodes(nodes);
                } else {
                    group = new Group(index, cg.name(), new Group.Distribution(cg.partitions(), config.redundancy()));
                }
                group.setCapacity(cg.capacity());
                if (path.length == 0) {
                    root = group;
                    continue;
                }
                Group parent = root;
                for (int j = 0; j < path.length - 1; ++j) {
                    parent = parent.getSubgroups().get(path[j]);
                }
                parent.addSubGroup(group);
            }
            if (root == null) {
                throw new IllegalStateException("Config does not specify a root group");
            }
            root.calculateDistributionHashValues();
            this.config.setRelease(new Config(root, config.redundancy()));
        }
        catch (ParseException e) {
            throw new IllegalStateException("Failed to parse config", e);
        }
    };

    public Group getRootGroup() {
        return this.config.getAcquire().nodeGraph;
    }

    public int getRedundancy() {
        return this.config.getAcquire().redundancy;
    }

    private static int[] getGroupPath(String path) {
        if (path.equals("invalid")) {
            return new int[0];
        }
        StringTokenizer st = new StringTokenizer(path, ".");
        int[] p = new int[st.countTokens()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = Integer.parseInt(st.nextToken());
        }
        return p;
    }

    private void configure(DistributionConfig.Cluster config) {
        try {
            Group root = null;
            for (int i = 0; i < config.group().size(); ++i) {
                Group group;
                int index;
                DistributionConfig.Cluster.Group cg = config.group(i);
                int[] path = new int[]{};
                if (root != null) {
                    path = Distribution.getGroupPath(cg.index());
                }
                boolean isLeafGroup = cg.nodes().size() > 0;
                int n = index = path.length == 0 ? 0 : path[path.length - 1];
                if (isLeafGroup) {
                    group = new Group(index, cg.name());
                    ArrayList<ConfiguredNode> nodes = new ArrayList<ConfiguredNode>();
                    for (DistributionConfig.Cluster.Group.Nodes node : cg.nodes()) {
                        nodes.add(new ConfiguredNode(node.index(), node.retired()));
                    }
                    group.setNodes(nodes);
                } else {
                    group = new Group(index, cg.name(), new Group.Distribution(cg.partitions(), config.redundancy()));
                }
                group.setCapacity(cg.capacity());
                if (path.length == 0) {
                    root = group;
                    continue;
                }
                Group parent = root;
                for (int j = 0; j < path.length - 1; ++j) {
                    parent = parent.getSubgroups().get(path[j]);
                }
                parent.addSubGroup(group);
            }
            if (root == null) {
                throw new IllegalStateException("Config does not specify a root group");
            }
            root.calculateDistributionHashValues();
            this.config.setRelease(new Config(root, config.redundancy()));
        }
        catch (ParseException e) {
            throw new IllegalStateException("Failed to parse config", e);
        }
    }

    public Distribution(String configId) {
        try {
            this.configSub = new ConfigSubscriber();
            this.configSub.subscribe(this.configSubscriber, StorDistributionConfig.class, configId);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public Distribution(StorDistributionConfig config2) {
        this.configSubscriber.configure((ConfigInstance)config2);
    }

    public Distribution(DistributionConfig.Cluster config2) {
        this.configure(config2);
    }

    private static long lastNBits(long value, int n) {
        if (n < 0 || n > 63) {
            throw new IllegalArgumentException("n must be in [0, 63], but was " + n);
        }
        return value & (1L << n) - 1L;
    }

    public void close() {
        if (this.configSub != null) {
            this.configSub.close();
            this.configSub = null;
        }
        this.configSubscriber = null;
    }

    private int getGroupSeed(BucketId bucket, ClusterState state, Group group) {
        int seed = (int)Distribution.lastNBits(bucket.getRawId(), state.getDistributionBitCount());
        return seed ^= group.getDistributionHash();
    }

    private int getDistributorSeed(BucketId bucket, ClusterState state) {
        return (int)Distribution.lastNBits(bucket.getRawId(), state.getDistributionBitCount());
    }

    private int getStorageSeed(BucketId bucket, ClusterState state) {
        int seed = (int)Distribution.lastNBits(bucket.getRawId(), state.getDistributionBitCount());
        if (bucket.getUsedBits() > 33) {
            int usedBits = bucket.getUsedBits() - 1;
            seed ^= (int)Distribution.lastNBits(bucket.getRawId() >> 32, usedBits - 32) << 6;
        }
        return seed;
    }

    private static boolean allDistributorsDown(Group g, ClusterState clusterState) {
        if (g.isLeafGroup()) {
            for (ConfiguredNode node : g.getNodes()) {
                NodeState ns = clusterState.getNodeState(new Node(NodeType.DISTRIBUTOR, node.index()));
                if (!ns.getState().oneOf("ui")) continue;
                return false;
            }
        } else {
            for (Group childGroup : g.getSubgroups().values()) {
                if (Distribution.allDistributorsDown(childGroup, clusterState)) continue;
                return false;
            }
        }
        return true;
    }

    private Group getIdealDistributorGroup(BucketId bucket, ClusterState clusterState, Group parent, int redundancy) {
        if (parent.isLeafGroup()) {
            return parent;
        }
        int[] redundancyArray = parent.getDistribution().getRedundancyArray(redundancy);
        TreeSet<ScoredGroup> results = new TreeSet<ScoredGroup>();
        int seed = this.getGroupSeed(bucket, clusterState, parent);
        RandomGen random = new RandomGen(seed);
        int currentIndex = 0;
        for (Group g : parent.getSubgroups().values()) {
            while (g.getIndex() < currentIndex++) {
                random.nextDouble();
            }
            double score = random.nextDouble();
            if (Math.abs(g.getCapacity() - 1.0) > 1.0E-7) {
                score = Math.pow(score, 1.0 / g.getCapacity());
            }
            results.add(new ScoredGroup(g, score));
        }
        while (!results.isEmpty() && Distribution.allDistributorsDown(((ScoredGroup)results.first()).group, clusterState)) {
            results.remove(results.first());
        }
        if (results.isEmpty()) {
            return null;
        }
        return this.getIdealDistributorGroup(bucket, clusterState, ((ScoredGroup)results.first()).group, redundancyArray[0]);
    }

    private void getIdealGroups(BucketId bucketId, ClusterState clusterState, Group parent, int redundancy, List<ResultGroup> results) {
        if (parent.isLeafGroup()) {
            results.add(new ResultGroup(parent, redundancy));
            return;
        }
        int[] redundancyArray = parent.getDistribution().getRedundancyArray(redundancy);
        ArrayList<ScoredGroup> tmpResults = new ArrayList<ScoredGroup>();
        for (int i = 0; i < redundancyArray.length; ++i) {
            tmpResults.add(new ScoredGroup(null, 0.0));
        }
        int seed = this.getGroupSeed(bucketId, clusterState, parent);
        RandomGen random = new RandomGen(seed);
        int currentIndex = 0;
        Map<Integer, Group> subGroups = parent.getSubgroups();
        for (Map.Entry<Integer, Group> entry : subGroups.entrySet()) {
            while (entry.getKey() < currentIndex++) {
                random.nextDouble();
            }
            double score = random.nextDouble();
            if (entry.getValue().getCapacity() != 1.0) {
                score = Math.pow(score, 1.0 / entry.getValue().getCapacity());
            }
            if (!(score > ((ScoredGroup)tmpResults.get((int)(tmpResults.size() - 1))).score)) continue;
            tmpResults.add(new ScoredGroup(entry.getValue(), score));
            Collections.sort(tmpResults);
            tmpResults.remove(tmpResults.size() - 1);
        }
        for (int i = 0; i < tmpResults.size(); ++i) {
            Group group = ((ScoredGroup)tmpResults.get((int)i)).group;
            if (group == null) continue;
            this.getIdealGroups(bucketId, clusterState, group, redundancyArray[i], results);
        }
    }

    List<Integer> getIdealStorageNodes(ClusterState clusterState, BucketId bucket, String upStates) throws TooFewBucketBitsInUseException {
        ArrayList<Integer> resultNodes = new ArrayList<Integer>();
        if (bucket.getUsedBits() < clusterState.getDistributionBitCount()) {
            String msg = "Cannot get ideal state for bucket " + bucket + " using " + bucket.getUsedBits() + " bits when cluster uses " + clusterState.getDistributionBitCount() + " distribution bits.";
            throw new TooFewBucketBitsInUseException(msg);
        }
        ArrayList<ResultGroup> groupDistribution = new ArrayList<ResultGroup>();
        Config cfg = this.config.getAcquire();
        this.getIdealGroups(bucket, clusterState, cfg.nodeGraph, cfg.redundancy, groupDistribution);
        int seed = this.getStorageSeed(bucket, clusterState);
        RandomGen random = new RandomGen(seed);
        int randomIndex = 0;
        for (ResultGroup group : groupDistribution) {
            int redundancy = group.redundancy;
            List<ConfiguredNode> nodes = group.group.getNodes();
            LinkedList<ScoredNode> tmpResults = new LinkedList<ScoredNode>();
            for (int i = 0; i < redundancy; ++i) {
                tmpResults.add(ScoredNode.makeInvalid());
            }
            for (ConfiguredNode configuredNode : nodes) {
                NodeState nodeState = clusterState.getNodeState(new Node(NodeType.STORAGE, configuredNode.index()));
                if (!nodeState.getState().oneOf(upStates)) continue;
                if (configuredNode.index() != randomIndex) {
                    if (configuredNode.index() < randomIndex) {
                        random.setSeed(seed);
                        randomIndex = 0;
                    }
                    for (int k = randomIndex; k < configuredNode.index(); ++k) {
                        random.nextDouble();
                    }
                    randomIndex = configuredNode.index();
                }
                double score = random.nextDouble();
                ++randomIndex;
                if (nodeState.getCapacity() != 1.0) {
                    score = Math.pow(score, 1.0 / nodeState.getCapacity());
                }
                if (!(score > ((ScoredNode)tmpResults.getLast()).score)) continue;
                for (int i = 0; i < tmpResults.size(); ++i) {
                    if (!(score > ((ScoredNode)tmpResults.get((int)i)).score)) continue;
                    tmpResults.add(i, new ScoredNode(configuredNode.index(), score));
                    break;
                }
                tmpResults.removeLast();
            }
            for (ScoredNode node : tmpResults) {
                if (!node.valid()) continue;
                resultNodes.add(node.index);
            }
        }
        return resultNodes;
    }

    public int getIdealDistributorNode(ClusterState state, BucketId bucket, String upStates) throws TooFewBucketBitsInUseException, NoDistributorsAvailableException {
        if (bucket.getUsedBits() < state.getDistributionBitCount()) {
            throw new TooFewBucketBitsInUseException("Cannot get ideal state for bucket " + bucket + " using " + bucket.getUsedBits() + " bits when cluster uses " + state.getDistributionBitCount() + " distribution bits.");
        }
        Config cfg = this.config.getAcquire();
        Group idealGroup = this.getIdealDistributorGroup(bucket, state, cfg.nodeGraph, cfg.redundancy);
        if (idealGroup == null) {
            throw new NoDistributorsAvailableException("No distributors available in cluster state version " + state.getVersion());
        }
        int seed = this.getDistributorSeed(bucket, state);
        RandomGen random = new RandomGen(seed);
        int randomIndex = 0;
        List<ConfiguredNode> configuredNodes = idealGroup.getNodes();
        ScoredNode node = ScoredNode.makeInvalid();
        for (ConfiguredNode configuredNode : configuredNodes) {
            NodeState nodeState = state.getNodeState(new Node(NodeType.DISTRIBUTOR, configuredNode.index()));
            if (!nodeState.getState().oneOf(upStates)) continue;
            if (configuredNode.index() != randomIndex) {
                if (configuredNode.index() < randomIndex) {
                    random.setSeed(seed);
                    randomIndex = 0;
                }
                for (int k = randomIndex; k < configuredNode.index(); ++k) {
                    random.nextDouble();
                }
                randomIndex = configuredNode.index();
            }
            double score = random.nextDouble();
            ++randomIndex;
            if (Math.abs(nodeState.getCapacity() - 1.0) > 1.0E-7) {
                score = Math.pow(score, 1.0 / nodeState.getCapacity());
            }
            if (!(score > node.score)) continue;
            node = new ScoredNode(configuredNode.index(), score);
        }
        if (!node.valid()) {
            throw new NoDistributorsAvailableException("No available distributors in any of the given upstates '" + upStates + "'.");
        }
        return node.index;
    }

    private boolean visitGroups(GroupVisitor visitor, Map<Integer, Group> groups) {
        for (Group g : groups.values()) {
            if (!visitor.visitGroup(g)) {
                return false;
            }
            if (g.isLeafGroup() || this.visitGroups(visitor, g.getSubgroups())) continue;
            return false;
        }
        return true;
    }

    public void visitGroups(GroupVisitor visitor) {
        TreeMap<Integer, Group> groups = new TreeMap<Integer, Group>();
        Group nodeGraph = this.config.getAcquire().nodeGraph;
        groups.put(nodeGraph.getIndex(), nodeGraph);
        this.visitGroups(visitor, groups);
    }

    public Set<ConfiguredNode> getNodes() {
        final HashSet<ConfiguredNode> nodes = new HashSet<ConfiguredNode>();
        GroupVisitor visitor = new GroupVisitor(){

            @Override
            public boolean visitGroup(Group g) {
                if (g.isLeafGroup()) {
                    nodes.addAll(g.getNodes());
                }
                return true;
            }
        };
        this.visitGroups(visitor);
        return nodes;
    }

    public static String getDefaultDistributionConfig(int redundancy, int nodeCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("raw:redundancy ").append(redundancy).append("\n").append("group[1]\n").append("group[0].index \"invalid\"\n").append("group[0].name \"invalid\"\n").append("group[0].partitions \"*\"\n").append("group[0].nodes[").append(nodeCount).append("]\n");
        for (int i = 0; i < nodeCount; ++i) {
            sb.append("group[0].nodes[").append(i).append("].index ").append(i).append("\n");
        }
        return sb.toString();
    }

    private static class Config {
        private final Group nodeGraph;
        private final int redundancy;

        Config(Group nodeGraph, int redundancy) {
            this.nodeGraph = nodeGraph;
            this.redundancy = redundancy;
        }
    }

    private static class ScoredGroup
    implements Comparable<ScoredGroup> {
        Group group;
        double score;

        ScoredGroup(Group g, double score) {
            this.group = g;
            this.score = score;
        }

        @Override
        public int compareTo(ScoredGroup o) {
            return Double.compare(o.score, this.score);
        }
    }

    private static class ResultGroup
    implements Comparable<ResultGroup> {
        Group group;
        int redundancy;

        ResultGroup(Group group, int redundancy) {
            this.group = group;
            this.redundancy = redundancy;
        }

        @Override
        public int compareTo(ResultGroup o) {
            return this.group.compareTo(o.group);
        }
    }

    public static class TooFewBucketBitsInUseException
    extends Exception {
        TooFewBucketBitsInUseException(String message) {
            super(message);
        }
    }

    private static class ScoredNode {
        final double score;
        final int index;

        ScoredNode(int index, double score) {
            this.score = score;
            this.index = index;
        }

        boolean valid() {
            return this.index != -1;
        }

        static ScoredNode makeInvalid() {
            return new ScoredNode(-1, 0.0);
        }
    }

    public static class NoDistributorsAvailableException
    extends Exception {
        NoDistributorsAvailableException(String message) {
            super(message);
        }
    }
}

