/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib;

import com.yahoo.io.GrowableByteBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MetaEntry {
    public static int REMOVE_ENTRY = 1;
    public static int BODY_STRIPPED = 2;
    public static int BODY_IN_HEADER = 4;
    public static int UPDATE_ENTRY = 8;
    public static int COMPRESSED = 16;
    public static int SIZE = 32;
    public long timestamp = 0L;
    public int headerPos = 0;
    public int headerLen = 0;
    public int bodyPos = 0;
    public int bodyLen = 0;
    public byte flags = 0;

    public MetaEntry() {
    }

    public MetaEntry(byte[] buffer, int position) {
        ByteBuffer buf = ByteBuffer.wrap(buffer, position, SIZE);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.timestamp = buf.getLong();
        this.headerPos = buf.getInt();
        this.headerLen = buf.getInt();
        this.bodyPos = buf.getInt();
        this.bodyLen = buf.getInt();
        this.flags = buf.get();
    }

    public void serialize(GrowableByteBuffer buf) {
        ByteOrder originalOrder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(this.timestamp);
        buf.putInt(this.headerPos);
        buf.putInt(this.headerLen);
        buf.putInt(this.bodyPos);
        buf.putInt(this.bodyLen);
        buf.putInt((int)this.flags);
        buf.putInt(0);
        buf.order(originalOrder);
    }
}

