/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd.commons;

import ai.vespa.hosted.cd.Endpoint;
import ai.vespa.hosted.cd.EndpointAuthenticator;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.SSLParameters;

public class HttpEndpoint
implements Endpoint {
    private final URI endpoint;
    private final HttpClient client;
    private final EndpointAuthenticator authenticator;

    public HttpEndpoint(URI endpoint, EndpointAuthenticator authenticator) {
        this.endpoint = Objects.requireNonNull(endpoint);
        this.authenticator = Objects.requireNonNull(authenticator);
        SSLParameters sslParameters = new SSLParameters();
        sslParameters.setProtocols(new String[]{"TLSv1.2"});
        this.client = HttpClient.newBuilder().sslContext(authenticator.sslContext()).connectTimeout(Duration.ofSeconds(5L)).version(HttpClient.Version.HTTP_1_1).sslParameters(sslParameters).build();
    }

    public URI uri() {
        return this.endpoint;
    }

    public EndpointAuthenticator authenticator() {
        return this.authenticator;
    }

    public <T> HttpResponse<T> send(HttpRequest.Builder request, HttpResponse.BodyHandler<T> handler) {
        try {
            return this.client.send(this.authenticator.authenticated(request).build(), handler);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(String.valueOf(request.build()) + " failed: " + e.getMessage(), e);
        }
    }

    public HttpRequest.Builder request(String path, Map<String, String> properties) {
        return HttpRequest.newBuilder(this.endpoint.resolve(path + properties.entrySet().stream().map(entry -> URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&", path.contains("?") ? "&" : "?", ""))));
    }
}

