/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd.commons;

import ai.vespa.hosted.api.Properties;
import ai.vespa.hosted.cd.EndpointAuthenticator;
import com.yahoo.config.provision.SystemName;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.X509CertificateUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Optional;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public class DefaultEndpointAuthenticator
implements EndpointAuthenticator {
    private static final Logger logger = Logger.getLogger(DefaultEndpointAuthenticator.class.getName());
    private final boolean hasLocalTestConfig;

    public DefaultEndpointAuthenticator(SystemName system) {
        this.hasLocalTestConfig = system == SystemName.dev;
    }

    public SSLContext sslContext() {
        try {
            Path certificateFile = null;
            Path privateKeyFile = null;
            Optional credentialsRootProperty = Properties.getNonBlankProperty((String)"vespa.test.credentials.root");
            if (credentialsRootProperty.isPresent()) {
                Path credentialsRoot = Path.of((String)credentialsRootProperty.get(), new String[0]);
                certificateFile = credentialsRoot.resolve("cert");
                privateKeyFile = credentialsRoot.resolve("key");
            } else {
                if (Properties.dataPlaneCertificateFile().isPresent()) {
                    certificateFile = (Path)Properties.dataPlaneCertificateFile().get();
                }
                if (Properties.dataPlaneKeyFile().isPresent()) {
                    privateKeyFile = (Path)Properties.dataPlaneKeyFile().get();
                }
            }
            if (certificateFile != null && privateKeyFile != null) {
                X509Certificate certificate = X509CertificateUtils.fromPem((String)new String(Files.readAllBytes(certificateFile)));
                if (Instant.now().isBefore(certificate.getNotBefore().toInstant()) || Instant.now().isAfter(certificate.getNotAfter().toInstant())) {
                    throw new IllegalStateException("Certificate at '" + certificateFile + "' is valid between " + certificate.getNotBefore() + " and " + certificate.getNotAfter() + " \u2014 not now.");
                }
                PrivateKey privateKey = KeyUtils.fromPemEncodedPrivateKey((String)new String(Files.readAllBytes(privateKeyFile)));
                return new SslContextBuilder().withKeyStore(privateKey, certificate).build();
            }
            if (!this.hasLocalTestConfig) {
                logger.warning("##################################################################################\n# Data plane key and/or certificate missing; please specify                      #\n# '-DdataPlaneCertificateFile=/path/to/certificate' and                          #\n# '-DdataPlaneKeyFile=/path/to/private_key'.                                     #\n# Trying the default SSLContext, but this will most likely cause HTTP error 401. #\n##################################################################################");
            }
            return SSLContext.getDefault();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

