/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd;

import ai.vespa.hosted.cd.EnabledInInstances;
import ai.vespa.hosted.cd.TestRuntime;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

class EnabledInInstancesCondition
implements ExecutionCondition {
    EnabledInInstancesCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional annotation = AnnotationUtils.findAnnotation((Optional)context.getElement(), EnabledInInstances.class);
        if (annotation.isEmpty()) {
            return ConditionEvaluationResult.enabled((String)(EnabledInInstances.class.getSimpleName() + " is not present"));
        }
        List<String> enablingInstances = List.of(((EnabledInInstances)annotation.get()).value());
        String thisInstance = TestRuntime.get().application().instance();
        String reason = "Enabled in: %s. Current instance: %s.".formatted(enablingInstances.isEmpty() ? "no instances" : "instances " + String.join((CharSequence)", ", enablingInstances), thisInstance);
        return enablingInstances.contains(thisInstance) ? ConditionEvaluationResult.enabled((String)reason) : ConditionEvaluationResult.disabled((String)reason);
    }
}

