/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.Base62;
import com.yahoo.security.KeyId;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SealedSharedKey;
import com.yahoo.security.SecretSharedKey;
import com.yahoo.security.SharedKeyGenerator;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.Optional;
import org.bouncycastle.util.Arrays;

public class SharedKeyResealingSession {
    private final KeyPair ephemeralKeyPair;

    SharedKeyResealingSession(KeyPair ephemeralKeyPair) {
        this.ephemeralKeyPair = ephemeralKeyPair;
    }

    public static SharedKeyResealingSession newEphemeralSession() {
        return new SharedKeyResealingSession(KeyUtils.generateX25519KeyPair());
    }

    public ResealingRequest resealingRequestFor(SealedSharedKey sealedSharedKey) {
        return new ResealingRequest((XECPublicKey)this.ephemeralKeyPair.getPublic(), sealedSharedKey);
    }

    public static ResealingResponse reseal(ResealingRequest request, PrivateKeyProvider privateKeyProvider) {
        PrivateKey privKey = privateKeyProvider.privateKeyForId(request.sealedKey.keyId()).orElseThrow(() -> new IllegalArgumentException("Could not find a private key for key ID '%s'".formatted(request.sealedKey.keyId())));
        SecretSharedKey secretShared = SharedKeyGenerator.fromSealedKey(request.sealedKey, privKey);
        SecretSharedKey resealed = SharedKeyGenerator.reseal(secretShared, request.ephemeralPubKey, KeyId.ofString("resealed-token"));
        return new ResealingResponse(resealed.sealedSharedKey());
    }

    public SecretSharedKey openResealingResponse(ResealingResponse response) {
        return SharedKeyGenerator.fromSealedKey(response.resealedKey, this.ephemeralKeyPair.getPrivate());
    }

    public record ResealingRequest(XECPublicKey ephemeralPubKey, SealedSharedKey sealedKey) {
        private static final byte[] HEADER_BYTES = new byte[]{82, 83};
        private static final byte CURRENT_VERSION = 1;

        public String toSerializedString() {
            byte[] pubKeyBytes = KeyUtils.toRawX25519PublicKeyBytes(this.ephemeralPubKey);
            byte[] tokenBytes = this.sealedKey.toSerializedBytes();
            ByteBuffer encoded = ByteBuffer.allocate(HEADER_BYTES.length + 1 + 1 + pubKeyBytes.length + tokenBytes.length);
            encoded.put(HEADER_BYTES);
            encoded.put((byte)1);
            encoded.put((byte)pubKeyBytes.length);
            encoded.put(pubKeyBytes);
            encoded.put(tokenBytes);
            encoded.flip();
            byte[] encBytes = new byte[encoded.remaining()];
            encoded.get(encBytes);
            return Base62.codec().encode(encBytes);
        }

        public static ResealingRequest fromSerializedString(String request) {
            ResealingRequest.verifyInputStringNotTooLarge(request);
            byte[] rawBytes = Base62.codec().decode(request);
            if (rawBytes.length < HEADER_BYTES.length + 2) {
                throw new IllegalArgumentException("Resealing request too short to contain a header and key length");
            }
            ByteBuffer decoded = ByteBuffer.wrap(rawBytes);
            byte[] header = new byte[2];
            decoded.get(header);
            if (!Arrays.areEqual((byte[])header, (byte[])HEADER_BYTES)) {
                throw new IllegalArgumentException("No resealing request header found");
            }
            byte version = decoded.get();
            if (version != 1) {
                throw new IllegalArgumentException("Unsupported version in resealing request header");
            }
            int pubKeyLen = Byte.toUnsignedInt(decoded.get());
            byte[] pubKeyBytes = new byte[pubKeyLen];
            decoded.get(pubKeyBytes);
            byte[] rawTokenBytes = new byte[decoded.remaining()];
            decoded.get(rawTokenBytes);
            return new ResealingRequest(KeyUtils.fromRawX25519PublicKey(pubKeyBytes), SealedSharedKey.fromSerializedBytes(rawTokenBytes));
        }

        private static void verifyInputStringNotTooLarge(String tokenString) {
            if (tokenString.length() > 576) {
                throw new IllegalArgumentException("String is too long to possibly be a valid resealing request");
            }
        }
    }

    @FunctionalInterface
    public static interface PrivateKeyProvider {
        public Optional<PrivateKey> privateKeyForId(KeyId var1);
    }

    public record ResealingResponse(SealedSharedKey resealedKey) {
        public String toSerializedString() {
            return this.resealedKey.toTokenString();
        }

        public static ResealingResponse fromSerializedString(String response) {
            return new ResealingResponse(SealedSharedKey.fromTokenString(response));
        }
    }
}

