/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;

public class KeyId {
    public static final int MAX_KEY_ID_UTF8_LENGTH = 255;
    private final byte[] keyIdBytes;

    private KeyId(byte[] keyIdBytes) {
        if (keyIdBytes.length > 255) {
            throw new IllegalArgumentException("Key ID is too large to be encoded (max is %d, got %d)".formatted(255, keyIdBytes.length));
        }
        KeyId.verifyByteStringRoundtripsAsValidUtf8(keyIdBytes);
        this.keyIdBytes = keyIdBytes;
    }

    public static KeyId ofBytes(byte[] keyIdBytes) {
        Objects.requireNonNull(keyIdBytes);
        return new KeyId(Arrays.copyOf(keyIdBytes, keyIdBytes.length));
    }

    public static KeyId ofString(String keyId) {
        Objects.requireNonNull(keyId);
        return new KeyId(ArrayUtils.toUtf8Bytes(keyId));
    }

    public byte[] asBytes() {
        return this.keyIdBytes;
    }

    public String asString() {
        return ArrayUtils.fromUtf8Bytes(this.keyIdBytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyId keyId = (KeyId)o;
        return Arrays.equals(this.keyIdBytes, keyId.keyIdBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyIdBytes);
    }

    public String toString() {
        return "KeyId(%s)".formatted(this.asString());
    }

    private static void verifyByteStringRoundtripsAsValidUtf8(byte[] byteStr) {
        String asStr = ArrayUtils.fromUtf8Bytes(byteStr);
        byte[] asBytes = ArrayUtils.toUtf8Bytes(asStr);
        if (!Arrays.equals(byteStr, asBytes)) {
            throw new IllegalArgumentException("Key ID is not valid normalized UTF-8");
        }
    }
}

