/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import java.util.concurrent.atomic.AtomicLong;

public class TlsMetrics {
    private static final TlsMetrics instance = new TlsMetrics();
    private final AtomicLong capabilityChecksSucceeded = new AtomicLong(0L);
    private final AtomicLong capabilityChecksFailed = new AtomicLong(0L);

    private TlsMetrics() {
    }

    public static TlsMetrics instance() {
        return instance;
    }

    void incrementCapabilitiesSucceeded() {
        this.capabilityChecksSucceeded.incrementAndGet();
    }

    void incrementCapabilitiesFailed() {
        this.capabilityChecksFailed.incrementAndGet();
    }

    public Snapshot snapshot() {
        return new Snapshot(this);
    }

    public record Snapshot(long capabilityChecksSucceeded, long capabilityChecksFailed) {
        public static final Snapshot EMPTY = new Snapshot(0L, 0L);

        private Snapshot(TlsMetrics m) {
            this(m.capabilityChecksSucceeded.get(), m.capabilityChecksFailed.get());
        }

        public Diff changesSince(Snapshot previous) {
            return new Diff(this, previous);
        }
    }

    public record Diff(long capabilityChecksSucceeded, long capabilityChecksFailed) {
        private Diff(Snapshot current, Snapshot previous) {
            this(current.capabilityChecksSucceeded - previous.capabilityChecksSucceeded, current.capabilityChecksFailed - previous.capabilityChecksFailed);
        }
    }
}

