/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.KeyManagerUtils;
import com.yahoo.security.KeyStoreBuilder;
import com.yahoo.security.KeyStoreType;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.TrustManagerUtils;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.X509CertificateWithKey;
import com.yahoo.security.X509SslContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;

public class SslContextBuilder {
    private KeyStoreSupplier trustStoreSupplier = () -> null;
    private KeyStoreSupplier keyStoreSupplier = () -> null;
    private char[] keyStorePassword;
    private TrustManagerFactory trustManagerFactory = TrustManagerUtils::createDefaultX509TrustManager;
    private KeyManagerFactory keyManagerFactory = KeyManagerUtils::createDefaultX509KeyManager;
    private X509ExtendedKeyManager keyManager;
    private X509ExtendedTrustManager trustManager;

    public SslContextBuilder withTrustStore(Path file, KeyStoreType trustStoreType) {
        this.trustStoreSupplier = () -> KeyStoreBuilder.withType(trustStoreType).fromFile(file).build();
        return this;
    }

    public SslContextBuilder withTrustStore(KeyStore trustStore) {
        this.trustStoreSupplier = () -> trustStore;
        return this;
    }

    public SslContextBuilder withTrustStore(X509Certificate caCertificate) {
        return this.withTrustStore(List.of(caCertificate));
    }

    public SslContextBuilder withTrustStore(List<X509Certificate> caCertificates) {
        this.trustStoreSupplier = () -> SslContextBuilder.createTrustStore(caCertificates);
        return this;
    }

    public SslContextBuilder withTrustStore(Path pemEncodedCaCertificates) {
        this.trustStoreSupplier = () -> {
            List<X509Certificate> caCertificates = X509CertificateUtils.certificateListFromPem(new String(Files.readAllBytes(pemEncodedCaCertificates)));
            return SslContextBuilder.createTrustStore(caCertificates);
        };
        return this;
    }

    public SslContextBuilder withKeyStore(PrivateKey privateKey, X509Certificate certificate) {
        return this.withKeyStore(privateKey, List.of(certificate));
    }

    public SslContextBuilder withKeyStore(PrivateKey privateKey, List<X509Certificate> certificates) {
        return this.withKeyStore(List.of(new X509CertificateWithKey(certificates, privateKey)));
    }

    public SslContextBuilder withKeyStore(List<X509CertificateWithKey> clientCertificatesAndKeys) {
        if (clientCertificatesAndKeys.isEmpty()) {
            throw new IllegalArgumentException("clientCertificatesAndKeys cannot be empty");
        }
        this.keyStoreSupplier = () -> {
            KeyStoreBuilder keyStore = KeyStoreBuilder.withType(KeyStoreType.JKS);
            for (int i = 0; i < clientCertificatesAndKeys.size(); ++i) {
                X509CertificateWithKey certWithKey = (X509CertificateWithKey)clientCertificatesAndKeys.get(i);
                keyStore = keyStore.withKeyEntry("key" + i, certWithKey.privateKey(), certWithKey.certificateWithIntermediates());
            }
            return keyStore.build();
        };
        this.keyStorePassword = new char[0];
        return this;
    }

    public SslContextBuilder withKeyStore(KeyStore keyStore, char[] password) {
        this.keyStoreSupplier = () -> keyStore;
        this.keyStorePassword = password;
        return this;
    }

    public SslContextBuilder withKeyStore(Path file, char[] password, KeyStoreType keyStoreType) {
        this.keyStoreSupplier = () -> KeyStoreBuilder.withType(keyStoreType).fromFile(file, password).build();
        this.keyStorePassword = password;
        return this;
    }

    public SslContextBuilder withKeyStore(Path privateKeyPemFile, Path certificatesPemFile) {
        this.keyStoreSupplier = () -> {
            PrivateKey privateKey = KeyUtils.fromPemEncodedPrivateKey(new String(Files.readAllBytes(privateKeyPemFile)));
            List<X509Certificate> certificates = X509CertificateUtils.certificateListFromPem(new String(Files.readAllBytes(certificatesPemFile)));
            return KeyStoreBuilder.withType(KeyStoreType.JKS).withKeyEntry("default", privateKey, certificates).build();
        };
        this.keyStorePassword = new char[0];
        return this;
    }

    public SslContextBuilder withTrustManagerFactory(TrustManagerFactory trustManagersFactory) {
        this.trustManagerFactory = trustManagersFactory;
        return this;
    }

    public SslContextBuilder withKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
        return this;
    }

    public SslContextBuilder withKeyManager(X509ExtendedKeyManager keyManager) {
        this.keyManager = keyManager;
        return this;
    }

    public SslContextBuilder withTrustManager(X509ExtendedTrustManager trustManager) {
        this.trustManager = trustManager;
        return this;
    }

    public SSLContext build() {
        return this.buildContext().context();
    }

    public X509SslContext buildContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            X509ExtendedTrustManager trustManager = this.trustManager != null ? this.trustManager : this.trustManagerFactory.createTrustManager(this.trustStoreSupplier.get());
            X509ExtendedKeyManager keyManager = this.keyManager != null ? this.keyManager : this.keyManagerFactory.createKeyManager(this.keyStoreSupplier.get(), this.keyStorePassword);
            sslContext.init(new KeyManager[]{keyManager}, new TrustManager[]{trustManager}, null);
            X509SslContext x509SslContext = new X509SslContext(sslContext, trustManager, keyManager);
            return x509SslContext;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.keyStorePassword = null;
        }
    }

    private static KeyStore createTrustStore(List<X509Certificate> caCertificates) {
        return KeyStoreBuilder.withType(KeyStoreType.JKS).withCertificateEntries("cert", caCertificates).build();
    }

    private static interface KeyStoreSupplier {
        public KeyStore get() throws IOException, GeneralSecurityException;
    }

    @FunctionalInterface
    public static interface TrustManagerFactory {
        public X509ExtendedTrustManager createTrustManager(KeyStore var1) throws GeneralSecurityException;
    }

    @FunctionalInterface
    public static interface KeyManagerFactory {
        public X509ExtendedKeyManager createKeyManager(KeyStore var1, char[] var2) throws GeneralSecurityException;
    }
}

