/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public abstract class AggregationResult
extends ExpressionNode {
    public static final int classId = AggregationResult.registerClass((int)16464, AggregationResult.class);
    private ExpressionNode expression = null;
    private int tag = -1;

    public int getTag() {
        return this.tag;
    }

    public AggregationResult setTag(int tag) {
        this.tag = tag;
        return this;
    }

    public void merge(AggregationResult result) {
        this.onMerge(result);
    }

    public void postMerge() {
    }

    public abstract ResultNode getRank();

    public AggregationResult setExpression(ExpressionNode exp) {
        this.expression = exp;
        return this;
    }

    public ExpressionNode getExpression() {
        return this.expression;
    }

    protected abstract void onMerge(AggregationResult var1);

    @Override
    public ResultNode getResult() {
        return this.getRank();
    }

    @Override
    public void onPrepare() {
    }

    @Override
    public boolean onExecute() {
        return true;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        AggregationResult.serializeOptional((Serializer)buf, (Identifiable)this.expression);
        buf.putInt(null, this.tag);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.expression = (ExpressionNode)AggregationResult.deserializeOptional((Deserializer)buf);
        this.tag = buf.getInt(null);
    }

    @Override
    public AggregationResult clone() {
        AggregationResult obj = (AggregationResult)super.clone();
        if (this.expression != null) {
            obj.expression = this.expression.clone();
        }
        return obj;
    }

    @Override
    protected final boolean equalsExpression(ExpressionNode obj) {
        AggregationResult rhs = (AggregationResult)obj;
        if (!AggregationResult.equals((Object)this.expression, (Object)rhs.expression)) {
            return false;
        }
        if (this.tag != rhs.tag) {
            return false;
        }
        return this.equalsAggregation(rhs);
    }

    protected abstract boolean equalsAggregation(AggregationResult var1);

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("expression", (Object)this.expression);
        visitor.visit("tag", (Object)this.tag);
    }
}

